// Plugins
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import Fonts from 'unplugin-fonts/vite'
import Layouts from 'vite-plugin-vue-layouts'
import Vue from '@vitejs/plugin-vue'
import VueRouter from 'unplugin-vue-router/vite'
import Vuetify, { transformAssetUrls } from 'vite-plugin-vuetify'

// Utilities
import { defineConfig, loadEnv } from 'vite'
import { fileURLToPath, URL } from 'node:url'

// https://vitejs.dev/config/
export default defineConfig(({ command, mode }) => {
  // 加载环境变量
  const env = loadEnv(mode, process.cwd())
  
  return {
    // 基础配置
    base: '/',
    
    // 环境变量配置
    define: {
      __APP_ENV__: JSON.stringify(env.VITE_APP_ENV),
    },
    
    // 构建配置
    build: {
      // 生产环境移除 console
      minify: 'terser',
      terserOptions: {
        compress: {
          drop_console: mode === 'production',
          drop_debugger: mode === 'production',
        },
      },
      // 构建输出目录
      outDir: `dist-${mode}`,
      // 生成源码映射文件
      sourcemap: mode !== 'production',
    },
    
    // 插件配置
    plugins: [
      Vue({
        template: { transformAssetUrls }
      }),
      VueRouter(),
      Layouts(),
      // ... other plugins
    ],
    
    // 服务器配置
    server: {
      port: 30000,
      host: true,
      proxy: {
        '/api': {
          target: env.VITE_API_URL,
          changeOrigin: true,
          rewrite: (path) => path.replace(/^\/api/, ''),
        },
      },
    },

    resolve: {
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url))
      }
    },
  }
})
