import axios from 'axios'
import { authService } from '@/services/auth.service'

const request = axios.create({
  baseURL: import.meta.env.VITE_API_URL,
  timeout: 15000
})

// 请求拦截器
request.interceptors.request.use(
  async config => {
    try {
      if (authService.isAuthenticated()) {
        const token = await authService.getToken()
        config.headers.Authorization = `Bearer ${token}`
      }
    } catch (error) {
      console.error('Error fetching token:', error)
      // 可以在这里处理获取 token 失败的情况，比如重定向到登录页面
    }
    return config
  },
  error => {
    console.error('Request error:', error)
    return Promise.reject(error)
  }
)

// 响应拦截器
request.interceptors.response.use(
  response => response.data,
  error => {
    if (error.response) {
      switch (error.response.status) {
        case 401:
          console.error('Unauthorized, redirecting to login...')
          // 可以在这里触发登出逻辑或重定向
          break
        case 403:
          console.error('Forbidden, you do not have access to this resource.')
          break
        case 404:
          console.error('Resource not found.')
          break
        default:
          console.error('An error occurred:', error.message)
      }
    } else {
      console.error('Network error:', error)
    }
    return Promise.reject(error)
  }
)

export default request