import type { AxiosError } from 'axios'

export function handleApiError(error: AxiosError) {
  if (error.response) {
    switch (error.response.status) {
      case 401:
        // 处理未授权
        break
      case 403:
        // 处理禁止访问
        break
      case 404:
        // 处理未找到
        break
      case 500:
        // 处理服务器错误
        break
      default:
        // 处理其他错误
        break
    }
  }
  return Promise.reject(error)
} 