import axios from 'axios'

const API_KEY = 'your-api-key' // Replace with your actual API key
const API_URL = 'https://api.cognitive.microsofttranslator.com/translate?api-version=3.0' // Microsoft Translator API URL

export async function translateText(text: string, targetLang: string): Promise<string> {
  try {
    const response = await axios.post(API_URL, [{
      Text: text
    }], {
      headers: {
        'Ocp-Apim-Subscription-Key': API_KEY,
        'Content-Type': 'application/json',
        'Ocp-Apim-Subscription-Region': 'your-region' // Replace with your region
      },
      params: {
        'to': targetLang
      }
    })
    return response.data[0].translations[0].text
  } catch (error) {
    console.error('Translation failed:', error)
    throw error
  }
} 