import axios from 'axios'

// 创建 axios 实例
const http = axios.create({
  baseURL: import.meta.env.VITE_API_URL, // 使用环境变量中的 API 基础 URL
  timeout: 10000, // 请求超时时间
})

// 请求拦截器
http.interceptors.request.use(
  (config) => {
    // 在发送请求之前做些什么，比如添加 token
    const token = localStorage.getItem('token') // 假设 token 存储在 localStorage 中
    if (token) {
      config.headers.Authorization = `Bearer ${token}`
    }
    return config
  },
  (error) => {
    // 对请求错误做些什么
    return Promise.reject(error)
  }
)

// 响应拦截器
http.interceptors.response.use(
  (response) => {
    // 对响应数据做些什么
    return response
  },
  (error) => {
    // 对响应错误做些什么
    if (error.response) {
      switch (error.response.status) {
        case 401:
          // 处理未授权错误，比如重定向到登录页面
          console.error('Unauthorized, redirecting to login...')
          // 可以在这里触发登出逻辑或重定向
          break
        case 403:
          console.error('Forbidden, you do not have access to this resource.')
          break
        case 404:
          console.error('Resource not found.')
          break
        default:
          console.error('An error occurred:', error.message)
      }
    }
    return Promise.reject(error)
  }
)

export default http 