import { useUserStore } from '@/stores/user'
import type { NavigationGuardNext, RouteLocationNormalized } from 'vue-router'
import { msalInstance } from '@/config/auth'

export async function authGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext
) {
  const userStore = useUserStore()

  try {
    // 确保 MSAL 实例初始化
    await msalInstance.initialize()

    if (!userStore.isLoggedIn) {
      // 清空 localStorage 仅在第一次尝试时
      if (!localStorage.getItem('authAttempted')) {
        localStorage.clear()
        localStorage.setItem('authAttempted', 'true')
      }

      // 直接触发微软登录
      await userStore.login()
      return
    }

    // 如果用户已登录，继续导航
    next()
  } catch (error) {
    console.error('Auth check failed:', error)
    // 处理登录失败的情况
  }
} 