/**
 * plugins/vuetify.ts
 *
 * Framework documentation: https://vuetifyjs.com`
 */

// Styles
import '@mdi/font/css/materialdesignicons.css'
import 'vuetify/styles'

// Composables
import { createVuetify, type ThemeDefinition } from 'vuetify'
import { zhHans, en } from 'vuetify/locale'
import { aliases, mdi } from 'vuetify/iconsets/mdi'

// https://vuetifyjs.com/en/introduction/why-vuetify/#feature-guides

// 定义浅色主题
const lightTheme: ThemeDefinition = {
  dark: false,
  colors: {
    primary: '#1976D2',   // 主要颜色，用于主按钮、链接等
    secondary: '#424242', // 次要颜色，用于次要按钮等
    accent: '#82B1FF',    // 强调色，用于突出显示的元素
    error: '#FF5252',     // 错误颜色，用于错误提示
    info: '#2196F3',      // 信息颜色，用于信息提示
    success: '#4CAF50',   // 成功颜色，用于成功提示
    warning: '#FB8C00',   // 警告颜色，用于警告提示
    background: '#FFFFFF', // 背景颜色
    surface: '#FFFFFF',    // 表面颜色，用于卡片等
    'on-background': '#808080', // 设置背景上的文字颜色为灰色
    'on-surface': '#808080',    // 设置表面上的文字颜色为灰色
    'on-primary': '#808080',    // 主要颜色上的文字颜色
    'on-secondary': '#FFFFFF',  // 次要颜色上的文字颜色
    'on-error': '#FFFFFF',      // 错误颜色上的文字颜色
    'on-info': '#FFFFFF',       // 信息颜色上的文字颜色
    'on-success': '#FFFFFF',    // 成功颜色上的文字颜色
    'on-warning': '#FFFFFF',    // 警告颜色上的文字颜色
  },
  variables: {
    // 自定义 CSS 变量
    'border-color': '#EEEEEE',
    'border-radius': '4px',
    'spacing-default': '16px',
    'font-size-root': '16px', // 设置全局字体大小
  },
}

// 定义深色主题
const darkTheme: ThemeDefinition = {
  dark: true,
  colors: {
    primary: '#2196F3',
    secondary: '#424242',
    accent: '#FF4081',
    error: '#FF5252',
    info: '#2196F3',
    success: '#4CAF50',
    warning: '#FB8C00',
    background: '#121212',
    surface: '#212121',
    'on-background': '#FFFFFF',
    'on-surface': '#FFFFFF',
    'on-primary': '#FFFFFF',
    'on-secondary': '#FFFFFF',
    'on-error': '#FFFFFF',
    'on-info': '#FFFFFF',
    'on-success': '#FFFFFF',
    'on-warning': '#FFFFFF',
  },
  variables: {
    'border-color': '#333333',
    'border-radius': '4px',
    'spacing-default': '16px',
  },
}

// Define your translations
const messages = {
  en: {
    $vuetify: en, // Use Vuetify's English translations
    // Add more custom translations here
  },
  zh: {
    $vuetify: zhHans, // Use Vuetify's Chinese translations
    // Add more custom translations here
  },
}



// 创建并导出 Vuetify 实例
export default createVuetify({
  // 主题配置
  theme: {
    defaultTheme: 'light', // 默认使用浅色主题
    themes: {
      light: lightTheme,  // 使用 'light' 而不是 'lightTheme'
      dark: darkTheme,    // 使用 'dark' 而不是 'darkTheme'
    },
    // 主题变体配置
    variations: {
      colors: ['primary', 'secondary'],
      lighten: 1,
      darken: 2,
    },
  },

  // 国际化配置
  locale: {
    locale: 'en',
    fallback: 'zh',
    messages: { zhHans, en },
  },

  // 图标配置
  icons: {
    defaultSet: 'mdi',      // 默认图标集
    aliases,                // 图标别名
    sets: {
      mdi,                  // Material Design Icons
    },
  },

  // 默认组件配置
  defaults: {
    // 按钮默认配置
    VBtn: {
      variant: 'outlined',     // 默认使用描边样式
      color: 'primary',        // 默认使用主色
      rounded: 'lg',           // 圆角大小
      elevation: 2,            // 阴影深度
      style: {
        fontSize: '14px', // 设置按钮的默认字体大小
      },
    },
    // 卡片默认配置
    VCard: {
      elevation: 2,            // 阴影深度
      rounded: 'lg',           // 圆角大小
    },
    // 文本输入框默认配置
    VTextField: {
      variant: 'outlined',     // 描边样式
      density: 'comfortable',  // 舒适的密度
      color: 'primary',        // 主色
      style: {
        fontSize: '14px', // 设置文本输入框的默认字体大小
      },
    },
    // 表格默认配置
    VTable: {
      density: 'comfortable',  // 舒适的密度
    },
    // 导航抽屉默认配置
    VNavigationDrawer: {
      elevation: 2,            // 阴影深度
    },
    // 工具栏默认配置
    VToolbar: {
      elevation: 2,            // 阴影深度
    },
    // 列表默认配置
    VList: {
      density: 'comfortable',  // 舒适的密度
    },
  },

  // 显示配置
  display: {
    mobileBreakpoint: 'sm',    // 移动端断点
    thresholds: {
      xs: 0,
      sm: 600,
      md: 960,
      lg: 1280,
      xl: 1920,
      xxl: 2560,
    },
  },
})
