# Vuetify (Default)

This is the official scaffolding tool for Vuetify, designed to give you a head start in building your new Vuetify application. It sets up a base template with all the necessary configurations and standard directory structure, enabling you to begin development without the hassle of setting up the project from scratch.

## ❗️ Important Links

- 📄 [Docs](https://vuetifyjs.com/)
- 🚨 [Issues](https://issues.vuetifyjs.com/)
- 🏬 [Store](https://store.vuetifyjs.com/)
- 🎮 [Playground](https://play.vuetifyjs.com/)
- 💬 [Discord](https://community.vuetifyjs.com)

## 💿 Install

Set up your project using your preferred package manager. Use the corresponding command to install the dependencies:

| Package Manager                                                | Command        |
|---------------------------------------------------------------|----------------|
| [yarn](https://yarnpkg.com/getting-started)                   | `yarn install` |
| [npm](https://docs.npmjs.com/cli/v7/commands/npm-install)     | `npm install`  |
| [pnpm](https://pnpm.io/installation)                          | `pnpm install` |
| [bun](https://bun.sh/#getting-started)                        | `bun install`  |

After completing the installation, your environment is ready for Vuetify development.

## ✨ Features

- 🖼️ **Optimized Front-End Stack**: Leverage the latest Vue 3 and Vuetify 3 for a modern, reactive UI development experience. [Vue 3](https://v3.vuejs.org/) | [Vuetify 3](https://vuetifyjs.com/en/)
- 🗃️ **State Management**: Integrated with [Pinia](https://pinia.vuejs.org/), the intuitive, modular state management solution for Vue.
- 🚦 **Routing and Layouts**: Utilizes Vue Router for SPA navigation and vite-plugin-vue-layouts for organizing Vue file layouts. [Vue Router](https://router.vuejs.org/) | [vite-plugin-vue-layouts](https://github.com/JohnCampionJr/vite-plugin-vue-layouts)
- 💻 **Enhanced Development Experience**: Benefit from TypeScript's static type checking and the ESLint plugin suite for Vue, ensuring code quality and consistency. [TypeScript](https://www.typescriptlang.org/) | [ESLint Plugin Vue](https://eslint.vuejs.org/)
- ⚡ **Next-Gen Tooling**: Powered by Vite, experience fast cold starts and instant HMR (Hot Module Replacement). [Vite](https://vitejs.dev/)
- 🧩 **Automated Component Importing**: Streamline your workflow with unplugin-vue-components, automatically importing components as you use them. [unplugin-vue-components](https://github.com/antfu/unplugin-vue-components)
- 🛠️ **Strongly-Typed Vue**: Use vue-tsc for type-checking your Vue components, and enjoy a robust development experience. [vue-tsc](https://github.com/johnsoncodehk/volar/tree/master/packages/vue-tsc)

These features are curated to provide a seamless development experience from setup to deployment, ensuring that your Vuetify application is both powerful and maintainable.

## 💡 Usage

This section covers how to start the development server and build your project for production.

### Starting the Development Server

To start the development server with hot-reload, run the following command. The server will be accessible at [http://localhost:3000](http://localhost:3000):

```bash
yarn dev
```

(Repeat for npm, pnpm, and bun with respective commands.)

> Add NODE_OPTIONS='--no-warnings' to suppress the JSON import warnings that happen as part of the Vuetify import mapping. If you are on Node [v21.3.0](https://nodejs.org/en/blog/release/v21.3.0) or higher, you can change this to NODE_OPTIONS='--disable-warning=5401'. If you don't mind the warning, you can remove this from your package.json dev script.

### Building for Production

To build your project for production, use:

```bash
yarn build
```

(Repeat for npm, pnpm, and bun with respective commands.)

Once the build process is completed, your application will be ready for deployment in a production environment.

## 💪 Support Vuetify Development

This project is built with [Vuetify](https://vuetifyjs.com/en/), a UI Library with a comprehensive collection of Vue components. Vuetify is an MIT licensed Open Source project that has been made possible due to the generous contributions by our [sponsors and backers](https://vuetifyjs.com/introduction/sponsors-and-backers/). If you are interested in supporting this project, please consider:

- [Requesting Enterprise Support](https://support.vuetifyjs.com/)
- [Sponsoring John on Github](https://github.com/users/johnleider/sponsorship)
- [Sponsoring Kael on Github](https://github.com/users/kaelwd/sponsorship)
- [Supporting the team on Open Collective](https://opencollective.com/vuetify)
- [Becoming a sponsor on Patreon](https://www.patreon.com/vuetify)
- [Becoming a subscriber on Tidelift](https://tidelift.com/subscription/npm/vuetify)
- [Making a one-time donation with Paypal](https://paypal.me/vuetify)

## 📑 License
[MIT](http://opensource.org/licenses/MIT)

Copyright (c) 2016-present Vuetify, LLC


- **/node_modules**: 存放项目的所有依赖包，由 `npm` 或 `yarn` 自动生成。
- **/public**: 存放不需要经过 Webpack 处理的静态资源。
  - `index.html`: 应用的入口 HTML 文件。
- **/src**: 项目的源代码目录。
  - **/assets**: 存放静态资源，如图片、样式文件等。
  - **/components**: 存放 Vue 组件。
  - **/layouts**: 存放布局组件，用于定义页面的整体结构。
  - **/plugins**: 存放插件注册文件。
  - **/router**: 存放路由配置文件。
  - **/services**: 存放服务层代码，如 API 调用、身份验证等。
  - **/stores**: 存放状态管理代码，使用 Pinia。
  - **/views**: 存放页面视图组件。
  - `App.vue`: Vue 应用的根组件。
  - `main.ts`: 应用的入口文件，负责初始化应用。
  - `env.d.ts`: 环境变量的类型定义文件。
- **.env**: 存放环境变量的配置文件。
- **.gitignore**: 配置 Git 忽略的文件和目录。
- **index.html**: 应用的入口 HTML 文件。
- **package.json**: 项目的元数据文件，包含项目的依赖、脚本等。
- **tsconfig.json**: TypeScript 的配置文件。
- **vite.config.mts**: Vite 的配置文件。

## 使用说明

1. **安装依赖**:
   ```bash
   npm install
   ```

2. **运行开发服务器**:
   ```bash
   npm run dev
   ```

3. **构建生产版本**:
   ```bash
   npm run build
   ```

4. **预览生产版本**:
   ```bash
   npm run preview
   ```

## 环境变量

在 `.env` 文件中配置以下环境变量：

- `VITE_APP_URL`: 应用的基本 URL。
- `VITE_AZURE_CLIENT_ID`: Azure AD 应用的客户端 ID。
- `VITE_AZURE_TENANT_ID`: Azure AD 租户 ID。
- `VITE_API_URL`: API 的基础 URL。
- `VITE_USE_POPUP_LOGIN`: 是否使用弹出式登录。


/project-root
│
├── /node_modules # 项目依赖包
│
├── /public # 静态资源文件
│ └── index.html # 入口 HTML 文件
│
├── /src # 源代码目录
│ ├── /assets # 静态资源（图片、样式等）
│ ├── /components # Vue 组件
│ ├── /layouts # 布局组件
│ ├── /plugins # 插件注册
│ ├── /router # 路由配置
│ ├── /services # 服务层（API 调用、身份验证等）
│ ├── /stores # 状态管理（Pinia）
│ ├── /views # 页面视图
│ ├── App.vue # 根组件
│ ├── main.ts # 应用入口文件
│ └── env.d.ts # 环境变量类型定义
│
├── .env # 环境变量配置文件
├── .gitignore # Git 忽略文件配置
├── index.html # 入口 HTML 文件
├── package.json # 项目元数据和依赖
├── tsconfig.json # TypeScript 配置
└── vite.config.mts # Vite 配置文件
```

## HTTP 请求

本项目使用 `axios` 作为 HTTP 请求库，并在 `src/services/request.ts` 中配置了全局的请求和响应拦截器。

### 请求拦截器

- 在请求发送之前，可以在请求拦截器中添加认证 token 或其他请求头。

### 响应拦截器

- 在响应拦截器中，可以处理响应数据或错误，比如处理未授权错误并重定向到登录页面。

### 使用示例

在需要发送 HTTP 请求的地方，导入并使用 `http` 实例：