import { createRouter, createWebHistory, createWebHashHistory } from 'vue-router'
import { setupLayouts } from 'virtual:generated-layouts'
import { routes as autoRoutes } from 'vue-router/auto-routes'
import { authGuard } from './guards'

// 根据环境变量决定使用 hash 模式还是 history 模式
const useHashRoute = import.meta.env.VITE_USE_HASH_ROUTE === 'true'

// 根据环境变量决定是否使用自动路由
const useAutoRouter = import.meta.env.VITE_USE_AUTO_ROUTER === 'true'

// 手动配置的路由
const manualRoutes = [
  {
    path: '/',
    component: () => import('@/pages/index.vue'),
  },
  {
    path: '/login',
    component: () => import('@/pages/login.vue'),
  },
  // 添加更多手动配置的路由
]

const router = createRouter({
  history: useHashRoute ? createWebHashHistory(import.meta.env.BASE_URL) : createWebHistory(import.meta.env.BASE_URL),
  routes: useAutoRouter ? setupLayouts(autoRoutes) : manualRoutes,
})

// 添加全局路由守卫
router.beforeEach(authGuard)

// 错误处理
router.onError((err, to) => {
  if (err?.message?.includes?.('Failed to fetch dynamically imported module')) {
    if (!localStorage.getItem('vuetify:dynamic-reload')) {
      console.log('Reloading page to fix dynamic import error')
      localStorage.setItem('vuetify:dynamic-reload', 'true')
      location.assign(to.fullPath)
    } else {
      console.error('Dynamic import error, reloading page did not fix it', err)
    }
  } else {
    console.error(err)
  }
})

router.isReady().then(() => {
  localStorage.removeItem('vuetify:dynamic-reload')
})

export default router