import { useUserStore } from '@/stores/user'
import type { NavigationGuardNext, RouteLocationNormalized } from 'vue-router'
import { authService } from '@/services/auth.service'
import { msalInstance } from '@/config/auth'

export async function authGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext
) {
  const userStore = useUserStore()

  try {
    // 确保 MSAL 实例初始化
    await msalInstance.initialize()

    if (!userStore.isLoggedIn) {
      // 尝试静默登录
      const accounts = authService.getAllAccounts()
      if (accounts.length > 0) {
        await authService.getToken()
        await userStore.initialize()
        next()
        return
      }

      // 如果没有缓存的账户，触发登录
      await userStore.login()
      next()
    } else {
      next()
    }
  } catch (error) {
    console.error('Auth check failed:', error)
    next('/login') // 如果登录失败，重定向到登录页面
  }
} 