/**
 * main.ts
 *
 * Bootstraps Vuetify and other plugins then mounts the App`
 */

// Plugins
import { registerPlugins } from '@/plugins'
import { Table } from 'vxe-table'
import 'vxe-table/lib/style.css'

// Components
import App from './App.vue'

// Composables
import { createApp } from 'vue'
import { useUserStore } from '@/stores/user'
import { msalInstance } from '@/config/auth'

const app = createApp(App)
registerPlugins(app)

// Use VxeTable directly
app.use(Table)

const userStore = useUserStore()

// 初始化应用
async function initializeApp() {
  try {
    // 初始化 MSAL 实例
    await msalInstance.initialize()

    // 处理重定向回调
    msalInstance.handleRedirectPromise().then(async (response) => {
      if (response) {
        userStore.$patch((state) => {
          state.account = response.account
        })
        msalInstance.setActiveAccount(response.account)
      }
      // 初始化用户状态并检查登录
      await userStore.initialize()
      if (!userStore.isLoggedIn) {
        await userStore.login() // 触发 MSAL 登录
      }
    }).catch(error => {
      console.error('Redirect handling failed:', error)
    })
  } catch (error) {
    console.error('Initialization failed:', error)
  } finally {
    app.mount('#app')
  }
}

initializeApp()
