import { 
  PublicClientApplication,
  type Configuration
} from '@azure/msal-browser'

// MSAL 配置对象，定义了应用程序的身份验证设置
export const msalConfig: Configuration = {
  auth: {
    // Azure AD 应用的客户端 ID
    clientId: import.meta.env.VITE_AZURE_CLIENT_ID || '',
    // Azure AD 的授权 URL，包含租户 ID
    authority: `https://login.microsoftonline.com/${import.meta.env.VITE_AZURE_TENANT_ID || ''}`,
    // 登录成功后的重定向 URI，通常是应用的基本 URL
    redirectUri: import.meta.env.VITE_APP_URL || '',
  },
  cache: {
    // 缓存位置，localStorage 可以在页面刷新后保留用户的登录状态
    cacheLocation: 'localStorage',
    // 是否在 cookie 中存储身份验证状态，通常设置为 false
    storeAuthStateInCookie: false,
  },
  system: {
    // 允许使用本地代理
    allowNativeBroker: true,
    // 窗口哈希超时时间
    windowHashTimeout: 60000,
    // iframe 哈希超时时间
    iframeHashTimeout: 6000,
    // 加载框架超时时间
    loadFrameTimeout: 0,
  }
}

// 登录请求的配置，定义了请求的权限范围
export const loginRequest = {
  scopes: ['User.Read'] // 请求用户读取权限
}

// 获取令牌请求的配置，定义了请求的权限范围
export const tokenRequest = {
  scopes: ['User.Read', 'Mail.Read'] // 请求用户读取和邮件读取权限
}

// 是否使用弹出式登录，来自环境变量
export const usePopupLogin = import.meta.env.VITE_USE_POPUP_LOGIN === 'true'

// 是否使用弹出式注销，来自环境变量
export const usePopupLogout = import.meta.env.VITE_USE_POPUP_LOGOUT === 'true'

// 创建 MSAL 实例
export const msalInstance = new PublicClientApplication(msalConfig)