// This file is always executed before the App's index.js. It sets up most of
// Ejecta's functionality. It initializes some global properties, such as window
// dimensions and the userAgent, provides global functions such as setInterval()
// and setTimeout() and the console object, emulates a tiny bit of DOM
// functionality and sets up handlers for Touch events and others.

// Make 'window' the global scope
GameGlobal = self = window = this;
window.top = window.parent = window;

(function(window) {
    // The 'ej' object provides some basic info and utility functions
    var BiliGame = BCanvas;
    var BiliUtils = new BiliGame.GlobalUtils.Instance();
    var BiliExt = bl_ext;
    var BiliTouchInput = new BiliGame.TouchInput.Instance();

    // Create the default screen canvas
    var sharedCanvas = window.sharedCanvas;
    sharedCanvas.style = {};
    var _realSharedCanvas = BiliUtils.getSharedCanvas();
    _realSharedCanvas.width = BiliUtils.screenWidth;
    _realSharedCanvas.height = BiliUtils.screenHeight;
    sharedCanvas.getContext = _realSharedCanvas.getContext.bind(_realSharedCanvas);
    Object.defineProperties(sharedCanvas, {
        width: {
            get() {
                return _realSharedCanvas.width;
            },
            set(value) {
                return value;
            },
            enumerable: true,
            configurable: false,
        },
        height: {
            get() {
                return _realSharedCanvas.height;
            },
            set(value) {
                return value;
            },
            enumerable: true,
            configurable: false,
        },
    });

    window.__isSubContext = true;


    var openDataMsgHandlers = [];
    window._onMessageFromMainContext = function(data) {
        if (openDataMsgHandlers.length) {
            openDataMsgHandlers.forEach(cb => cb(JSON.parse(data)));
        }
    };

    var tempCanvas = new BiliGame.Canvas.Instance();
    var HTMLCanvasElementProto = Object.getPrototypeOf(tempCanvas);
    var getContextOld = HTMLCanvasElementProto.getContext;

    HTMLCanvasElementProto.getContext = function() {
        for (
            var _len = arguments.length, args = new Array(_len), _key = 0;
            _key < _len;
            _key++
        ) {
            args[_key] = arguments[_key];
        }
        if (args[0] === 'webgl') {
            return null;
        }

        return getContextOld.apply(this, args);
    };

    tempCanvas = null;

    var bl = (window.bl = {
        sharedCanvas: sharedCanvas,
        getSharedCanvas : function(){
            return sharedCanvas;
        },
        onMessage : function(msgHandler){
            openDataMsgHandlers.push(msgHandler);
        },
        createCanvas: function() {
            var tmp = new BiliGame.Canvas.Instance();
            tmp.style = {};
            return tmp;
        },
        createImage: function() {
            return new BiliGame.Image.Instance();
        },
        onTouchStart: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.addEventListener('touchstart', callback);
        },
        offTouchStart: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.removeEventListener('touchstart', callback);
        },
        onTouchMove: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.addEventListener('touchmove', function(touchevt) {
                callback(touchevt);
            });
        },
        offTouchMove: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.removeEventListener('touchmove', callback);
        },
        onTouchEnd: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.addEventListener('touchend', callback);
        },
        offTouchEnd: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.removeEventListener('touchend', callback);
        },
        onTouchCancel: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.addEventListener('touchcancel', callback);
        },
        offTouchCancel: function(callback) {
            if (!callback) {
                return;
            }
            BiliTouchInput.removeEventListener('touchcancel', callback);
        },
    });

    if (BiliUtils.requireModuleAdvanced) {
        window.bl.requireModule = function(a, b, c, d) {
            return BiliUtils.requireModuleAdvanced(a, b, c, d);
        };
    }
    //TODO proxy to blapi
    window.localStorage = {};
    // Timers
    window.performance = {
        now: function() {
            return BiliExt.performanceNow();
        },
    };

    var timeoutOld = window.setTimeout;
    var setIntervalOld = window.setInterval;
    var clearTimeoutOld = window.clearTimeout;
    var clearIntervalOld = window.clearInterval;
    var requestAnimationFrameOld = window.requestAnimationFrame;
    var cancelAnimationFrameOld = window.cancelAnimationFrame;
    window.setTimeout = function(cb, t) {
        return timeoutOld(cb, t || 0);
    };
    window.setInterval = function(cb, t) {
        return setIntervalOld(cb, t || 0);
    };
    window.clearTimeout = function(id) {
        return clearTimeoutOld(id);
    };
    window.clearInterval = function(id) {
        return clearIntervalOld(id);
    };
    window.requestAnimationFrame = function(cb, element) {
        return requestAnimationFrameOld(function() {
            cb(BiliExt.performanceNow());
        });
    };
    window.cancelAnimationFrame = function(id) {
        return cancelAnimationFrameOld(id);
    };

    // Set up the screen properties and useragent
    window.devicePixelRatio = BiliUtils.devicePixelRatio;
    window.innerWidth = BiliUtils.screenWidth;
    window.innerHeight = BiliUtils.screenHeight;

    window.screen = {
        availWidth: window.innerWidth,
        availHeight: window.innerHeight,
    };
    window.wx = window.bl;
    window.navigator = {
        language: window._locale,
        userAgent:
            'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Mobile/14E8301 MicroMessenger/6.6.0 MiniGame NetType/WIFI Language/zh_CN', //hard code like weixin
        appVersion: '5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1', //hard code like weixin
        platform: '', //TODO read from getSystemInfo
        get onLine() {
            return BiliExt.isOnline();
        }, // re-evaluate on each get
        //TODO proxy to blapi
        //        get geolocation() { // Lazily create geolocation instance
        //            geolocation = geolocation || new Ejecta.Geolocation();
        //            return geolocation;
        //        }
    };

    // The console object
    var serialize = (function() {
        var isMixed = function(obj) {
            return /\[object (Object)|(Array)\]/.test(Object.prototype.toString.call(obj));
        };

        try {
            // 尝试使用Proxy
            var tempProxy = new Proxy({}, {});

            var handler = function(rootPath = '@') {
                var self = this;

                return {
                    get: function(target, key) {
                        var result = Reflect.get(target, key);
                        var descriptor = Object.getOwnPropertyDescriptor(target, key);

                        if (isMixed(result)) {
                            var cacheKey = Array.isArray(target) ? `${rootPath}[${key}]` : `${rootPath}.${key}`;
                            var filtered = self.filter(function(a) {
                                return a.value === result;
                            });

                            if (filtered.length) {
                                return `<Circular ${filtered[0].key}>`;
                            }

                            self.push({ key: cacheKey, value: result });
                            return new Proxy(result, handler.call(self, cacheKey));
                        }

                        if (typeof result === 'function' && descriptor.enumerable) {
                            return '<Function>';
                        }

                        return result;
                    },
                };
            };

            return function(obj, space) {
                if (isMixed(obj)) {
                    var caches = [{ key: '@', value: obj }];
                    var proxy = new Proxy(obj, handler.call(caches));
                    return "'" + JSON.stringify(proxy, null, space) + "'";
                }

                return "'" + JSON.stringify(obj, null, space) + "'";
            };
        } catch (e) {
            console.error(e);
            // 兼容方案
            return function(object) {
                var trap = [];
                return (
                    "'" +
                    JSON.stringify(object, (key, value) => {
                        if (isMixed(value)) {
                            if (
                                trap.reduce((prev, curr) => {
                                    return curr.value === value || prev;
                                }, false)
                            ) {
                                return '<Circular>';
                            } else {
                                trap.push({ key, value });
                                return value;
                            }
                        } else if (typeof value === 'function') {
                            return '<Function>';
                        }
                        return value;
                    }) +
                    "'"
                );
            };
        }
    })();
    var needSerialize = window.console.isDebug;
    var consoleDebugOld = window.console.debug;
    var consoleInfoOld = window.console.info;
    var consoleWarnOld = window.console.warn;
    var consoleErrorOld = window.console.error;
    var consoleLogOld = window.console.log;

    if (window.consoleV2) {
        var consoleDebugNew = window.consoleV2.debug;
        var consoleInfoNew = window.consoleV2.info;
        var consoleWarnNew = window.consoleV2.warn;
        var consoleErrorNew = window.consoleV2.error;
        var consoleLogNew = window.consoleV2.log;
        var consoleAssertNew = window.consoleV2.assert;
        window.console.debug = function() {
            consoleDebugNew.apply(window.consoleV2, arguments);
        };
        window.console.info = function() {
            consoleInfoNew.apply(window.consoleV2, arguments);
        };
        window.console.warn = function() {
            consoleWarnNew.apply(window.consoleV2, arguments);
        };
        window.console.error = function() {
            consoleErrorNew.apply(window.consoleV2, arguments);
        };
        window.console.log = function() {
            consoleLogNew.apply(window.consoleV2, arguments);
        };
        window.console.assert = function() {
            consoleAssertNew.apply(window.consoleV2, arguments);
        };
    } else {
        window.console.debug = function() {
            if (!needSerialize) {
                consoleDebugOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleDebugOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.assert = function() {
            if (!needSerialize) {
                consoleLogOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleLogOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.log = function() {
            if (!needSerialize) {
                consoleLogOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleLogOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.info = function() {
            if (!needSerialize) {
                consoleInfoOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleInfoOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.warn = function() {
            if (!needSerialize) {
                consoleWarnOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleWarnOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.error = function() {
            if (!needSerialize) {
                consoleErrorOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleErrorOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };
    }

    var consoleTimers = {};
    console.time = function(name) {
        consoleTimers[name] = BiliExt.performanceNow();
    };

    console.timeEnd = function(name) {
        var timeStart = consoleTimers[name];
        if (!timeStart) {
            return;
        }

        var timeElapsed = BiliExt.performanceNow() - timeStart;
        console.log(name + ': ' + timeElapsed + 'ms');
        delete consoleTimers[name];
    };

    // The native Image, Audio, HttpRequest and LocalStorage class mimic the real elements
    window.Image = BiliGame.Image.Instance;
    //TODO NOT IMPLEMENTED
    //    window.Video = Ejecta.Video;
    //TODO proxy to blapi
    //    window.XMLHttpRequest = Ejecta.HttpRequest;

    //TODO NOT IMPLEMENTED
    //    window.WebSocket = Ejecta.WebSocket;

    window.Event = function(type) {
        this.type = type;
        this.cancelBubble = false;
        this.cancelable = false;
        this.target = null;
        this.timestamp = BiliExt.performanceNow();

        this.initEvent = function(type, bubbles, cancelable) {
            this.type = type;
            this.cancelBubble = bubbles;
            this.cancelable = cancelable;
            this.timestamp = BiliExt.performanceNow();
        };

        this.preventDefault = function() {};
        this.stopPropagation = function() {};
    };

    window.location = {
        href: 'game.js',
    };
    window.location.reload = function() {
        //TODO
        //ejecta.load('index.js');
    };

    window.open = function(url) {
        // TODO
        // ej.openURL(url);
    };

    // Set up a 'fake' HTMLElement
    HTMLElement = function(tagName) {
        this.tagName = tagName.toUpperCase();
        this.children = [];
        this.style = {};
    };

    // TODO
    HTMLElement.prototype.appendChild = function (element) {
    //        this.children.push(element);
    //
    //        // If the child is a script element, begin to load it or execute it
    //        if (element.tagName && element.tagName.toLowerCase() == 'script') {
    //            if (element.src) {
    //                setTimeout(function () {
    //                    bl.include(element.src);
    //                    if (element.onload) {
    //                        element.onload({
    //                            type: 'load',
    //                            currentTarget: element
    //                        });
    //                    }
    //                }, 1);
    //            } else if (element.text) {
    //                window.eval(element.text);
    //            }
    //        }
    };

    HTMLElement.prototype.insertBefore = function(newElement, existingElement) {
        // Just append; we don't care about order here
        this.appendChild(newElement);
    };

    HTMLElement.prototype.removeChild = function(node) {
        for (var i = this.children.length; i--; ) {
            if (this.children[i] === node) {
                this.children.splice(i, 1);
            }
        }
    };

    HTMLElement.prototype.getBoundingClientRect = function() {
        return {
            top: 0,
            left: 0,
            width: window.innerWidth,
            height: window.innerHeight,
        };
    };

    HTMLElement.prototype.setAttribute = function(attr, value) {
        this[attr] = value;
    };

    HTMLElement.prototype.getAttribute = function(attr) {
        return this[attr];
    };

    HTMLElement.prototype.addEventListener = function(event, method) {
        if (event === 'load') {
            this.onload = method;
        }
    };

    HTMLElement.prototype.removeEventListener = function(event, method) {
        if (event === 'load') {
            this.onload = undefined;
        }
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError('Cannot call a class as a function');
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }
        return call && (typeof call === 'object' || typeof call === 'function') ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== 'function' && superClass !== null) {
            throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass);
        }
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true,
            },
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : (subClass.__proto__ = superClass);
    }

    HTMLImageElement = (function(_HTMLElement) {
        _inherits(HTMLImageElement, _HTMLElement);

        function HTMLImageElement() {
            _classCallCheck(this, HTMLImageElement);

            return _possibleConstructorReturn(this, (HTMLImageElement.__proto__ || Object.getPrototypeOf(HTMLImageElement)).call(this, 'img'));
        }

        return HTMLImageElement;
    })(HTMLElement);

    HTMLCanvasElement = (function(_HTMLElement) {
        _inherits(HTMLCanvasElement, _HTMLElement);

        function HTMLCanvasElement() {
            _classCallCheck(this, HTMLCanvasElement);

            return _possibleConstructorReturn(this, (HTMLCanvasElement.__proto__ || Object.getPrototypeOf(HTMLCanvasElement)).call(this, 'canvas'));
        }

        return HTMLCanvasElement;
    })(HTMLElement);

    HTMLVideoElement = function(_HTMLElement) {
        _inherits(HTMLVideoElement, _HTMLElement);

        function HTMLVideoElement() {
            _classCallCheck(this, HTMLVideoElement);

            return _possibleConstructorReturn(this, (HTMLVideoElement.__proto__ || Object.getPrototypeOf(HTMLVideoElement)).call(this, 'video'));
        }

        return HTMLVideoElement;
    };

    // The document object
    window.document = {
        readyState: 'complete',
        documentElement: window,
        location: window.location,
        visibilityState: 'visible',
        hidden: false,
        style: {},

        head: new HTMLElement('head'),
        body: new HTMLElement('body'),

        events: {},

        createElement: function(name) {
            if (name === 'canvas') {
                var canvas = bl.createCanvas();
                return canvas;
            }
            // TODO proxy to blapi
            //            else if (name == 'audio') {
            //                return new Ejecta.Audio();
            //            } else if (name == 'video') {
            //                return new Ejecta.Video();
            //            }
            else if (name === 'img') {
                return bl.createImage();
            }
            // TODO NOT IMPLEMENTED
            //            else if (name === 'input' || name === 'textarea') {
            //                return new Ejecta.KeyInput();
            //            }
            return new HTMLElement(name);
        },

        createElementNS: function(namespace, name) {
            if (name === 'canvas') {
                var canvas = bl.createCanvas();
                return canvas;
            }
            // TODO proxy to blapi
            //            else if (name == 'audio') {
            //                return new Ejecta.Audio();
            //            } else if (name == 'video') {
            //                return new Ejecta.Video();
            //            }
            else if (name === 'img') {
                return bl.createImage();
            }
            // TODO NOT IMPLEMENTED
            //            else if (name === 'input' || name === 'textarea') {
            //                return new Ejecta.KeyInput();
            //            }
            return new HTMLElement(name);
        },

        createTextNode: function() {
            return new HTMLElement('div');
        },

        getElementById: function(id) {
            if (id === 'canvas') {
                return window.sharedCanvas;
            }
            return null;
        },

        getElementsByTagName: function(tagName) {
            var elements = [],
                children,
                i;

            tagName = tagName.toLowerCase();

            if (tagName === 'head') {
                elements.push(document.head);
            } else if (tagName === 'body') {
                elements.push(document.body);
            } else {
                children = document.body.children;
                for (i = 0; i < children.length; i++) {
                    if (children[i].tagName.toLowerCase() === tagName) {
                        elements.push(children[i]);
                    }
                }
                children = undefined;
            }
            return elements;
        },

        createEvent: function(type) {
            return new window.Event(type);
        },

        addEventListener: function(type, callback, useCapture) {
            if (type == 'DOMContentLoaded') {
                window.setTimeout(callback, 1);
                return;
            }
            if (!this.events[type]) {
                this.events[type] = [];

                // call the event initializer, if this is the first time we
                // bind to this event.
                if (typeof this._eventInitializers[type] == 'function') {
                    this._eventInitializers[type]();
                }
            }
            this.events[type].push(callback);
        },

        removeEventListener: function(type, callback) {
            var listeners = this.events[type];
            if (!listeners) {
                return;
            }

            for (var i = listeners.length; i--; ) {
                if (listeners[i] === callback) {
                    listeners.splice(i, 1);
                }
            }
        },

        _eventInitializers: {},
        dispatchEvent: function(event) {
            var listeners = this.events[event.type];
            if (!listeners) {
                return;
            }

            for (var i = 0; i < listeners.length; i++) {
                listeners[i](event);
            }
        },
    };

    var eventInit = document._eventInitializers;
    // Touch events

    // Set touch event properties for feature detection
    window.ontouchstart = window.ontouchend = window.ontouchmove = null;
    document.ontouchstart = document.ontouchend = document.ontouchmove = null;

    // Setting up the 'event' object for touch events in native code is quite
    // a bit of work, so instead we do it here in JavaScript and have the native
    // touch class just call a simple callback.
    var touchInput = null;
    var touchEvent = {
        type: 'touchstart',
        target: window.sharedCanvas,
        currentTarget: window.sharedCanvas,
        touches: null,
        targetTouches: null,
        changedTouches: null,
        timestamp: 0,
        preventDefault: function() {},
        stopPropagation: function() {},
    };

    var dispatchTouchEvent = function(type, touchEvt) {
        touchEvent.touches = touchEvt.touches;
        touchEvent.targetTouches = touchEvt.touches;
        touchEvent.changedTouches = touchEvt.changedTouches;
        touchEvent.type = type;
        touchEvent.timestamp = touchEvt.timeStamp;

        document.dispatchEvent(touchEvent);
    };
    eventInit.touchstart = eventInit.touchend = eventInit.touchmove = function() {
        if (touchInput) {
            return;
        }

        bl.onTouchStart(dispatchTouchEvent.bind(window, 'touchstart'));
        bl.onTouchEnd(dispatchTouchEvent.bind(window, 'touchend'));
        bl.onTouchMove(dispatchTouchEvent.bind(window, 'touchmove'));
        bl.onTouchCancel(dispatchTouchEvent.bind(window, 'touchcancel'));
    };
})(this);
