// This file is always executed before the App's index.js. It sets up most of
// Ejecta's functionality. It initializes some global properties, such as window
// dimensions and the userAgent, provides global functions such as setInterval()
// and setTimeout() and the console object, emulates a tiny bit of DOM
// functionality and sets up handlers for Touch events and others.

// Make 'window' the global scope
GameGlobal = self = window = this;
window.top = window.parent = window;

(function(window) {
    // The 'ej' object provides some basic info and utility functions
    var BiliGame = BCanvas;
    var BiliUtils = new BiliGame.GlobalUtils.Instance();
    var BiliExt = bl_ext;
    var BiliTouchInput = new BiliGame.TouchInput.Instance();
    if(BiliUtils && BiliUtils.BILI_BASETYPE && window) {
        window.BILI_BASETYPE = BiliUtils.BILI_BASETYPE
    }
    
    if(BiliUtils && BiliUtils.executeCommands) {
        window._executeCommands = function(cmds, array) {
            return BiliUtils.executeCommands(cmds, array);
        }
    }

    // Create the default screen canvas
    var screenCanvas = window.canvas;
    screenCanvas.style = {};
    if (window.sharedCanvas) {
        var sharedCanvas = window.sharedCanvas;
        sharedCanvas.style = {};
        var _realSharedCanvas = BiliUtils.getSharedCanvas();
        _realSharedCanvas.width = BiliUtils.screenWidth;
        _realSharedCanvas.height = BiliUtils.screenHeight;
        sharedCanvas.getContext = _realSharedCanvas.getContext.bind(_realSharedCanvas);
        Object.defineProperties(sharedCanvas, {
            width: {
                get() {
                    return _realSharedCanvas.width;
                },
                set(value) {
                    return _realSharedCanvas.width = value;
                },
                enumerable: true,
                configurable: false,
            },
            height: {
                get() {
                    return _realSharedCanvas.height;
                },
                set(value) {
                    return _realSharedCanvas.height = value;
                },
                enumerable: true,
                configurable: false,
            },
        });
    } else {
        window.sharedCanvas = new (function() {return this})();
    }

    window.__SmallApp.fileSystemManager = new BiliGame.FileSystemManager.Instance();

    function SocketObject(id, target) {
        this.id = id;
        this.target = target;
        return this;
    }

    SocketObject.prototype.close = function(options) {
        try {
            this.target.close(options.code || 1000);
            options && options.success && typeof options.success === 'function' && options.success({ errMsg: 'close:ok' });
            options && options.complete && typeof options.complete === 'function' && options.complete({ errMsg: 'close:ok' });
        } catch (e) {
            options && options.fail && typeof options.fail === 'function' && options.fail({ errMsg: 'close:fail' });
            options && options.complete && typeof options.complete === 'function' && options.complete({ errMsg: 'close:fail' });
        }
    };

    SocketObject.prototype.send = function(options) {
        try {
            this.target.send(options.data);
            options && options.success && typeof options.success === 'function' && options.success({ errMsg: 'close:ok' });
            options && options.complete && typeof options.complete === 'function' && options.complete({ errMsg: 'close:ok' });
        } catch (e) {
            options && options.fail && typeof options.fail === 'function' && options.fail({ errMsg: 'close:fail' });
            options && options.complete && typeof options.complete === 'function' && options.complete({ errMsg: 'close:fail' });
        }
    };

    SocketObject.prototype.onClose = function(callback) {
        this.target.onclose = callback;
    };

    SocketObject.prototype.onOpen = function(callback) {
        this.target.onopen = callback;
    };

    SocketObject.prototype.onError = function(callback) {
        this.target.onerror = callback;
    };

    SocketObject.prototype.onMessage = function(callback) {
        this.target.onmessage = callback;
    };

    SocketObject.uid = 0;

    const oldWebSocket = window.WebSocket;

    var openDataContext = {
        canvas: sharedCanvas,
        postMessage: function(data) {
            if (window._postMessageToOpenDataContext) {
                _postMessageToOpenDataContext(JSON.stringify(data));
            }
        },
    };

    var onScreen = true;
    var addSetPropertyFun = function(canvas){
        if(canvas && canvas.style) {
            canvas.style.setProperty = function (property, value, option){
                if(typeof option == 'undefined') {
                    option = ''
                }
                if(property == 'width') {
                    canvas.style.width = `${value}${option}`
                } else if(property == 'height') {
                    canvas.style.height = `${value}${option}`
                } else {
                    console.warn('暂不支持除了宽高以外的属性');
                }
            }
        }
    }
    var touchendMap = [];
    var __touchendMap = [];
    var touchendCallbackMap = [];
    var __touchendCallbackMap = [];
    var touchStartMap = [];
    var __touchStartMap = [];
    var touchMoveMap = [];
    var __touchMoveMap = [];
    var touchCancelMap = [];
    var __touchCancelMap = [];
    var bl = (window.bl = {
        postMessage: openDataContext.postMessage,
        getOpenDataContext: function() {
            return openDataContext;
        },
        createCanvas: function() {
            if (onScreen) {
                onScreen = false;
                addSetPropertyFun(screenCanvas);
                return screenCanvas;
            } else {
                var tmp = new BiliGame.Canvas.Instance();
                tmp.style = {};
                addSetPropertyFun(tmp);
                return tmp;
            }
        },
        createImage: function() {
            return new BiliGame.Image.Instance();
        },
        onTouchStart: function(callback, __isFramework) {
            if (typeof callback != 'function') {
                return;
            }
            if(__isFramework == true) {
                __touchStartMap.push(callback);
            } else {
                touchStartMap.push(callback);
            }
            BiliTouchInput.addEventListener('touchstart', callback);
        },
        offTouchStart: function(callback, __isFramework) {
            var tempArray;
            if(__isFramework == true) {
                tempArray = __touchStartMap;
            } else {
                tempArray = touchStartMap;
            }
            if (typeof callback != 'function') {
                tempArray.forEach(function(cb) {
                    BiliTouchInput.removeEventListener('touchstart', cb);
                })
                tempArray.splice(0, tempArray.length);
            } else {
                var index = tempArray.indexOf(callback);
                if(index != -1) {
                    BiliTouchInput.removeEventListener('touchstart', callback);
                    tempArray.splice(index, 1);
                }
            }
        },
        onTouchMove: function(callback, __isFramework) {
            if (typeof callback != 'function') {
                return;
            }
            if(__isFramework == true) {
                __touchMoveMap.push(callback);
            } else {
                touchMoveMap.push(callback);
            }
            BiliTouchInput.addEventListener('touchmove', callback);
        },
        offTouchMove: function(callback, __isFramework) {
            var tempArray;
            if(__isFramework == true) {
                tempArray = __touchMoveMap;
            } else {
                tempArray = touchMoveMap;
            }
            if (typeof callback != 'function') {
                tempArray.forEach(function(cb) {
                    BiliTouchInput.removeEventListener('touchmove', cb);
                })
                tempArray.splice(0, tempArray.length);
            } else {
                var index = tempArray.indexOf(callback);
                if(index != -1) {
                    BiliTouchInput.removeEventListener('touchmove', callback);
                    tempArray.splice(index, 1);
                }
            }
        },
        onTouchEnd: function(callback, __isFramework) {
            if (typeof callback != 'function') {
                return;
            }
            const cb = function() {
                window.__SmallApp.__intouchend = true;
                try {
                    callback.apply(this, arguments);
                    delete window.__SmallApp.__intouchend;
                } catch(err) {
                    delete window.__SmallApp.__intouchend;
                    throw err;
                }
            };
            if(__isFramework == true) {
                __touchendMap.push(cb);
                __touchendCallbackMap.push(callback);
            } else {
                touchendMap.push(cb);
                touchendCallbackMap.push(callback);
            }
            BiliTouchInput.addEventListener('touchend', cb);
        },
        offTouchEnd: function(callback, __isFramework) {
            var tempArray;
            var tempEndArray;
            if(__isFramework == true) {
                tempArray = __touchendMap;
                tempEndArray = __touchendCallbackMap;
            } else {
                tempArray = touchendMap;
                tempEndArray = touchendCallbackMap;
            }
            if (typeof callback != 'function') {
                tempArray.forEach(function(cb) {
                    BiliTouchInput.removeEventListener('touchend', cb);
                })
                tempArray.splice(0, tempArray.length);
                tempEndArray.splice(0, tempEndArray.length);
            } else {
                var index = tempEndArray.indexOf(callback);
                if(index != -1) {
                    BiliTouchInput.removeEventListener('touchend', tempArray[index]);
                    tempArray.splice(index, 1);
                    tempEndArray.splice(index, 1);
                }
            }
        },
        onTouchCancel: function(callback, __isFramework) {
            if (typeof callback != 'function') {
                return;
            }
            if(__isFramework == true) {
                __touchCancelMap.push(callback);
            } else {
               touchCancelMap.push(callback);
            }
            BiliTouchInput.addEventListener('touchcancel', callback);
        },
        offTouchCancel: function(callback, __isFramework) {
            var tempArray;
            if(__isFramework == true) {
                tempArray = __touchCancelMap;
            } else {
                tempArray = touchCancelMap;
            }
            if (typeof callback != 'function') {
                tempArray.forEach(function(cb) {
                    BiliTouchInput.removeEventListener('touchcancel', cb);
                })
                tempArray.splice(0, tempArray.length);
            } else {
                var index = tempArray.indexOf(callback);
                if(index != -1) {
                    BiliTouchInput.removeEventListener('touchcancel', callback);
                    tempArray.splice(index, 1);
                }
            }
        },
        connectSocket: function(options) {
            var url = options.url;
            var protocols = options.protocols;
            var header = options.header;
            var tcpNoDelay = options.tcpNoDelay;
            return new SocketObject(SocketObject.uid++, new oldWebSocket(url, protocols, header, tcpNoDelay));
        },
        loadFont: function(e) {
            return BiliUtils.loadFont(e);
        },
        //TODO proxy to blapi
        //        createInnerAudioContext : function (){
        //            return {};
        //        },
        //TODO proxy to blapi
        //        requireModule : function (a,b,c,d) {
        //            return _internalBL.requireModule(a,b,c,d);
        //        },
        //TODO proxy to blapi
        //        getFileSystemManager : function (){
        //            return _internalBL.getFileSystemManager();
        //        },
        //TODO proxy to blapi
        //        getTextLineHeight : function (e){
        //            return _internalBL.getTextLineHeight(e);
        //        },
    });

    if (BiliUtils.requireModuleAdvanced) {
        window.bl.requireModule = function(a, b, c, d) {
            return BiliUtils.requireModuleAdvanced(a, b, c, d);
        };
    }
    //    touchEvent.touches = touchEvt.touches;
    //            touchEvent.targetTouches = touchEvt.targetTouches;
    //            touchEvent.changedTouches = touchEvt.changedTouches;
    //            touchEvent.type = touchEvt.type;
    //            touchEvent.timestamp = touchEvt.stimestamp;

    //TODO proxy to blapi
    window.localStorage = {};
    // Timers
    window.performance = {
        now: function() {
            return BiliExt.performanceNow();
        },
    };
    var timeoutOld = window.setTimeout;
    var setIntervalOld = window.setInterval;
    var clearTimeoutOld = window.clearTimeout;
    var clearIntervalOld = window.clearInterval;
    var requestAnimationFrameOld = window.requestAnimationFrame;
    var cancelAnimationFrameOld = window.cancelAnimationFrame;
    window.setTimeout = function(cb, t) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
        }
        return timeoutOld(function () {
            cb.apply(void 0, args);
        }, t || 0);
    };
    window.setInterval = function(cb, t) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
        }
        return setIntervalOld(function () {
            cb.apply(void 0, args);
        }, t || 0);
    };
    window.clearTimeout = function(id) {
        return clearTimeoutOld(id);
    };
    window.clearInterval = function(id) {
        return clearIntervalOld(id);
    };
    window.requestAnimationFrame = function(cb, element) {
        return requestAnimationFrameOld(function() {
            cb(BiliExt.performanceNow());
        });
    };
    window.cancelAnimationFrame = function(id) {
        return cancelAnimationFrameOld(id);
    };

    // Set up the screen properties and useragent
    window.devicePixelRatio = BiliUtils.devicePixelRatio;
    window.innerWidth = BiliUtils.screenWidth;
    window.innerHeight = BiliUtils.screenHeight;

    // TODO NOT IMPLEMENTED
    //    Object.defineProperty(window, 'orientation', {
    //        get: function () {
    //            return ej.orientation;
    //        }
    //    });

    window.screen = {
        availWidth: window.innerWidth,
        availHeight: window.innerHeight,
    };

    //    var geolocation = null;

    window.wx = window.bl;
    window.navigator = {
        language: window._locale,
        userAgent:
            'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Mobile/14E8301 MicroMessenger/6.6.0 MiniGame NetType/WIFI Language/zh_CN', //hard code like weixin
        appVersion: '5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1', //hard code like weixin
        platform: '', //TODO read from getSystemInfo
        get onLine() {
            return BiliExt.isOnline();
        }, // re-evaluate on each get
        //TODO proxy to blapi
        //        get geolocation() { // Lazily create geolocation instance
        //            geolocation = geolocation || new Ejecta.Geolocation();
        //            return geolocation;
        //        }
    };

    // The console object
    var serialize = (function() {
        var isMixed = function(obj) {
            return /\[object (Object)|(Array)\]/.test(Object.prototype.toString.call(obj));
        };

        try {
            // 尝试使用Proxy
            var tempProxy = new Proxy({}, {});

            var handler = function(rootPath = '@') {
                var self = this;

                return {
                    get: function(target, key) {
                        var result = Reflect.get(target, key);
                        var descriptor = Object.getOwnPropertyDescriptor(target, key);

                        if (isMixed(result)) {
                            var cacheKey = Array.isArray(target) ? `${rootPath}[${key}]` : `${rootPath}.${key}`;
                            var filtered = self.filter(function(a) {
                                return a.value === result;
                            });

                            if (filtered.length) {
                                return `<Circular ${filtered[0].key}>`;
                            }

                            self.push({ key: cacheKey, value: result });
                            return new Proxy(result, handler.call(self, cacheKey));
                        }

                        if (typeof result === 'function' && descriptor.enumerable) {
                            return '<Function>';
                        }

                        return result;
                    },
                };
            };

            return function(obj, space) {
                if (isMixed(obj)) {
                    var caches = [{ key: '@', value: obj }];
                    var proxy = new Proxy(obj, handler.call(caches));
                    return "'" + JSON.stringify(proxy, null, space) + "'";
                }

                return "'" + JSON.stringify(obj, null, space) + "'";
            };
        } catch (e) {
            console.error(e);
            // 兼容方案
            return function(object) {
                var trap = [];
                return (
                    "'" +
                    JSON.stringify(object, (key, value) => {
                        if (isMixed(value)) {
                            if (
                                trap.reduce((prev, curr) => {
                                    return curr.value === value || prev;
                                }, false)
                            ) {
                                return '<Circular>';
                            } else {
                                trap.push({ key, value });
                                return value;
                            }
                        } else if (typeof value === 'function') {
                            return '<Function>';
                        }
                        return value;
                    }) +
                    "'"
                );
            };
        }
    })();
    var needSerialize = window.console.isDebug;
    var consoleDebugOld = window.console.debug;
    var consoleInfoOld = window.console.info;
    var consoleWarnOld = window.console.warn;
    var consoleErrorOld = window.console.error;
    var consoleLogOld = window.console.log;

    if (window.consoleV2) {
        var consoleDebugNew = window.consoleV2.debug;
        var consoleInfoNew = window.consoleV2.info;
        var consoleWarnNew = window.consoleV2.warn;
        var consoleErrorNew = window.consoleV2.error;
        var consoleLogNew = window.consoleV2.log;
        var consoleAssertNew = window.consoleV2.assert;
        window.console.debug = function() {
            consoleDebugNew.apply(window.consoleV2, arguments);
        };
        window.console.info = function() {
            consoleInfoNew.apply(window.consoleV2, arguments);
        };
        window.console.warn = function() {
            consoleWarnNew.apply(window.consoleV2, arguments);
        };
        window.console.error = function() {
            consoleErrorNew.apply(window.consoleV2, arguments);
        };
        window.console.log = function() {
            consoleLogNew.apply(window.consoleV2, arguments);
        };
        window.console.assert = function() {
            consoleAssertNew.apply(window.consoleV2, arguments);
        };
    } else {
        window.console.debug = function() {
            if (!needSerialize) {
                consoleDebugOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleDebugOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.assert = function() {
            if (!needSerialize) {
                consoleLogOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleLogOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.log = function() {
            if (!needSerialize) {
                consoleLogOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleLogOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.info = function() {
            if (!needSerialize) {
                consoleInfoOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleInfoOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.warn = function() {
            if (!needSerialize) {
                consoleWarnOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleWarnOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };

        window.console.error = function() {
            if (!needSerialize) {
                consoleErrorOld.apply(window.console, arguments);
                return;
            }

            for (var i = 0; i < arguments.length; i++) {
                try {
                    consoleErrorOld(serialize(arguments[i]));
                } catch (e) {
                    consoleErrorOld(JSON.stringify(e.message));
                }
            }
        };
    }

    var consoleTimers = {};
    console.time = function(name) {
        consoleTimers[name] = BiliExt.performanceNow();
    };

    console.timeEnd = function(name) {
        var timeStart = consoleTimers[name];
        if (!timeStart) {
            return;
        }

        var timeElapsed = BiliExt.performanceNow() - timeStart;
        console.log(name + ': ' + timeElapsed + 'ms');
        delete consoleTimers[name];
    };

    // The native Image, Audio, HttpRequest and LocalStorage class mimic the real elements
    window.Image = BiliGame.Image.Instance;
    //TODO NOT IMPLEMENTED
    //    window.Video = Ejecta.Video;
    //TODO proxy to blapi
    //    window.XMLHttpRequest = Ejecta.HttpRequest;

    //TODO NOT IMPLEMENTED
    //    window.WebSocket = Ejecta.WebSocket;

    window.Event = function(type) {
        this.type = type;
        this.cancelBubble = false;
        this.cancelable = false;
        this.target = null;
        this.timestamp = BiliExt.performanceNow();

        this.initEvent = function(type, bubbles, cancelable) {
            this.type = type;
            this.cancelBubble = bubbles;
            this.cancelable = cancelable;
            this.timestamp = BiliExt.performanceNow();
        };

        this.preventDefault = function() {};
        this.stopPropagation = function() {};
    };

    window.location = {
        href: 'game.js',
    };
    window.location.reload = function() {
        //TODO
        //ejecta.load('index.js');
    };

    window.open = function(url) {
        // TODO
        // ej.openURL(url);
    };

    // Set up a 'fake' HTMLElement
    HTMLElement = function(tagName) {
        this.tagName = tagName.toUpperCase();
        this.children = [];
        this.style = {};
    };

    // TODO
    HTMLElement.prototype.appendChild = function (element) {
    //        this.children.push(element);
    //
    //        // If the child is a script element, begin to load it or execute it
    //        if (element.tagName && element.tagName.toLowerCase() == 'script') {
    //            if (element.src) {
    //                setTimeout(function () {
    //                    bl.include(element.src);
    //                    if (element.onload) {
    //                        element.onload({
    //                            type: 'load',
    //                            currentTarget: element
    //                        });
    //                    }
    //                }, 1);
    //            } else if (element.text) {
    //                window.eval(element.text);
    //            }
    //        }
    };

    HTMLElement.prototype.insertBefore = function(newElement, existingElement) {
        // Just append; we don't care about order here
        this.appendChild(newElement);
    };

    HTMLElement.prototype.removeChild = function(node) {
        for (var i = this.children.length; i--; ) {
            if (this.children[i] === node) {
                this.children.splice(i, 1);
            }
        }
    };

    HTMLElement.prototype.getBoundingClientRect = function() {
        return {
            top: 0,
            left: 0,
            width: window.innerWidth,
            height: window.innerHeight,
        };
    };

    HTMLElement.prototype.setAttribute = function(attr, value) {
        this[attr] = value;
    };

    HTMLElement.prototype.getAttribute = function(attr) {
        return this[attr];
    };

    HTMLElement.prototype.addEventListener = function(event, method) {
        if (event === 'load') {
            this.onload = method;
        }
    };

    HTMLElement.prototype.removeEventListener = function(event, method) {
        if (event === 'load') {
            this.onload = undefined;
        }
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError('Cannot call a class as a function');
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }
        return call && (typeof call === 'object' || typeof call === 'function') ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== 'function' && superClass !== null) {
            throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass);
        }
        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true,
            },
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : (subClass.__proto__ = superClass);
    }

    HTMLImageElement = (function(_HTMLElement) {
        _inherits(HTMLImageElement, _HTMLElement);

        function HTMLImageElement() {
            _classCallCheck(this, HTMLImageElement);

            return _possibleConstructorReturn(this, (HTMLImageElement.__proto__ || Object.getPrototypeOf(HTMLImageElement)).call(this, 'img'));
        }

        return HTMLImageElement;
    })(HTMLElement);

    HTMLCanvasElement = (function(_HTMLElement) {
        _inherits(HTMLCanvasElement, _HTMLElement);

        function HTMLCanvasElement() {
            _classCallCheck(this, HTMLCanvasElement);

            return _possibleConstructorReturn(this, (HTMLCanvasElement.__proto__ || Object.getPrototypeOf(HTMLCanvasElement)).call(this, 'canvas'));
        }

        return HTMLCanvasElement;
    })(HTMLElement);

    HTMLVideoElement = function(_HTMLElement) {
        _inherits(HTMLVideoElement, _HTMLElement);

        function HTMLVideoElement() {
            _classCallCheck(this, HTMLVideoElement);

            return _possibleConstructorReturn(this, (HTMLVideoElement.__proto__ || Object.getPrototypeOf(HTMLVideoElement)).call(this, 'video'));
        }

        return HTMLVideoElement;
    };

    // The document object
    window.document = {
        readyState: 'complete',
        documentElement: window,
        location: window.location,
        visibilityState: 'visible',
        hidden: false,
        style: {},

        head: new HTMLElement('head'),
        body: new HTMLElement('body'),

        events: {},

        createElement: function(name) {
            if (name === 'canvas') {
                var canvas = bl.createCanvas();
                return canvas;
            }
            // TODO proxy to blapi
            //            else if (name == 'audio') {
            //                return new Ejecta.Audio();
            //            } else if (name == 'video') {
            //                return new Ejecta.Video();
            //            }
            else if (name === 'img') {
                return bl.createImage();
            }
            // TODO NOT IMPLEMENTED
            //            else if (name === 'input' || name === 'textarea') {
            //                return new Ejecta.KeyInput();
            //            }
            return new HTMLElement(name);
        },

        createElementNS: function(namespace, name) {
            if (name === 'canvas') {
                var canvas = bl.createCanvas();
                return canvas;
            }
            // TODO proxy to blapi
            //            else if (name == 'audio') {
            //                return new Ejecta.Audio();
            //            } else if (name == 'video') {
            //                return new Ejecta.Video();
            //            }
            else if (name === 'img') {
                return bl.createImage();
            }
            // TODO NOT IMPLEMENTED
            //            else if (name === 'input' || name === 'textarea') {
            //                return new Ejecta.KeyInput();
            //            }
            return new HTMLElement(name);
        },

        createTextNode: function() {
            return new HTMLElement('div');
        },

        getElementById: function(id) {
            if (id === 'canvas') {
                return window.canvas;
            }
            return null;
        },

        getElementsByTagName: function(tagName) {
            var elements = [],
                children,
                i;

            tagName = tagName.toLowerCase();

            if (tagName === 'head') {
                elements.push(document.head);
            } else if (tagName === 'body') {
                elements.push(document.body);
            } else {
                children = document.body.children;
                for (i = 0; i < children.length; i++) {
                    if (children[i].tagName.toLowerCase() === tagName) {
                        elements.push(children[i]);
                    }
                }
                children = undefined;
            }
            return elements;
        },

        createEvent: function(type) {
            return new window.Event(type);
        },

        addEventListener: function(type, callback, useCapture) {
            if (type == 'DOMContentLoaded') {
                window.setTimeout(callback, 1);
                return;
            }
            if (!this.events[type]) {
                this.events[type] = [];

                // call the event initializer, if this is the first time we
                // bind to this event.
                if (typeof this._eventInitializers[type] == 'function') {
                    this._eventInitializers[type]();
                }
            }
            this.events[type].push(callback);
        },

        removeEventListener: function(type, callback) {
            var listeners = this.events[type];
            if (!listeners) {
                return;
            }

            for (var i = listeners.length; i--; ) {
                if (listeners[i] === callback) {
                    listeners.splice(i, 1);
                }
            }
        },

        _eventInitializers: {},
        dispatchEvent: function(event) {
            var listeners = this.events[event.type];
            if (!listeners) {
                return;
            }

            for (var i = 0; i < listeners.length; i++) {
                listeners[i](event);
            }
        },
    };

    window.canvas.addEventListener = window.addEventListener = function(type, callback) {
        window.document.addEventListener(type, callback);
    };
    window.canvas.removeEventListener = window.removeEventListener = function(type, callback) {
        window.document.removeEventListener(type, callback);
    };
    window.canvas.getBoundingClientRect = function() {
        return {
            top: 0,
            left: 0,
            width: window.innerWidth,
            height: window.innerHeight,
        };
    };

    var eventInit = document._eventInitializers;

    // Touch events

    // Set touch event properties for feature detection
    window.ontouchstart = window.ontouchend = window.ontouchmove = null;
    document.ontouchstart = document.ontouchend = document.ontouchmove = null;

    // Setting up the 'event' object for touch events in native code is quite
    // a bit of work, so instead we do it here in JavaScript and have the native
    // touch class just call a simple callback.
    var touchInput = null;
    var touchEvent = {
        type: 'touchstart',
        target: window.canvas,
        currentTarget: window.canvas,
        touches: null,
        targetTouches: null,
        changedTouches: null,
        timestamp: 0,
        preventDefault: function() {},
        stopPropagation: function() {},
    };

    var dispatchTouchEvent = function(type, touchEvt) {
        touchEvent.touches = touchEvt.touches;
        touchEvent.targetTouches = touchEvt.touches;
        touchEvent.changedTouches = touchEvt.changedTouches;
        touchEvent.type = type;
        touchEvent.timestamp = touchEvt.timeStamp;

        document.dispatchEvent(touchEvent);
    };
    eventInit.touchstart = function(){
        if (touchInput) {
            return;
        }
        bl.onTouchStart(dispatchTouchEvent.bind(window, 'touchstart'), true);
    }
    eventInit.touchend = function(){
        if (touchInput) {
            return;
        }
        bl.onTouchEnd(dispatchTouchEvent.bind(window, 'touchend'), true);
    }
    eventInit.touchmove = function(){
        if (touchInput) {
            return;
        }
        bl.onTouchMove(dispatchTouchEvent.bind(window, 'touchmove'), true);
    }
    eventInit.touchcancel = function(){
        if (touchInput) {
            return;
        }
        bl.onTouchCancel(dispatchTouchEvent.bind(window, 'touchcancel'), true);
    }
        
    // eventInit.touchstart = eventInit.touchend = eventInit.touchmove = function() {
    //     if (touchInput) {
    //         return;
    //     }

    //     bl.onTouchStart(dispatchTouchEvent.bind(window, 'touchstart'));
    //     bl.onTouchEnd(dispatchTouchEvent.bind(window, 'touchend'));
    //     bl.onTouchMove(dispatchTouchEvent.bind(window, 'touchmove'));
    //     bl.onTouchCancel(dispatchTouchEvent.bind(window, 'touchcancel'));
    // };

    // TODO WAIT IMPLEMENT
    // DeviceMotion and DeviceOrientation events
    //    var deviceMotion = null;
    //    var deviceMotionEvent = {
    //        type: 'devicemotion',
    //        target: window.canvas,
    //        currentTarget: window.canvas,
    //        interval: 16,
    //        acceleration: {
    //            x: 0,
    //            y: 0,
    //            z: 0
    //        },
    //        accelerationIncludingGravity: {
    //            x: 0,
    //            y: 0,
    //            z: 0
    //        },
    //        rotationRate: {
    //            alpha: 0,
    //            beta: 0,
    //            gamma: 0
    //        },
    //        timestamp: 0,
    //        preventDefault: function () {},
    //        stopPropagation: function () {}
    //    };
    //
    //    var deviceOrientationEvent = {
    //        type: 'deviceorientation',
    //        target: window.canvas,
    //        currentTarget: window.canvas,
    //        alpha: null,
    //        beta: null,
    //        gamma: null,
    //        absolute: true,
    //        timestamp: 0,
    //        preventDefault: function () {},
    //        stopPropagation: function () {}
    //    };
    //
    //    eventInit.deviceorientation = eventInit.devicemotion = function () {
    //        if (deviceMotion) {
    //            return;
    //        }
    //
    //        deviceMotion = new Ejecta.DeviceMotion();
    //        deviceMotionEvent.interval = deviceMotion.interval;
    //
    //        // Callback for Devices that have a Gyro
    //        deviceMotion.ondevicemotion = function (agx, agy, agz, ax, ay, az, rx, ry, rz, ox, oy, oz, timestamp) {
    //            deviceMotionEvent.accelerationIncludingGravity.x = agx;
    //            deviceMotionEvent.accelerationIncludingGravity.y = agy;
    //            deviceMotionEvent.accelerationIncludingGravity.z = agz;
    //
    //            deviceMotionEvent.acceleration.x = ax;
    //            deviceMotionEvent.acceleration.y = ay;
    //            deviceMotionEvent.acceleration.z = az;
    //
    //            deviceMotionEvent.rotationRate.alpha = rx;
    //            deviceMotionEvent.rotationRate.beta = ry;
    //            deviceMotionEvent.rotationRate.gamma = rz;
    //
    //            deviceMotionEvent.timestamp = timestamp;
    //
    //            document.dispatchEvent(deviceMotionEvent);
    //
    //
    //            deviceOrientationEvent.alpha = ox;
    //            deviceOrientationEvent.beta = oy;
    //            deviceOrientationEvent.gamma = oz;
    //
    //            deviceOrientationEvent.timestamp = timestamp;
    //
    //            document.dispatchEvent(deviceOrientationEvent);
    //        };
    //
    //        // Callback for Devices that only have an accelerometer
    //        deviceMotion.onacceleration = function (agx, agy, agz, timestamp) {
    //            deviceMotionEvent.accelerationIncludingGravity.x = agx;
    //            deviceMotionEvent.accelerationIncludingGravity.y = agy;
    //            deviceMotionEvent.accelerationIncludingGravity.z = agz;
    //
    //            deviceMotionEvent.acceleration = null;
    //            deviceMotionEvent.rotationRate = null;
    //
    //            deviceMotionEvent.timestamp = timestamp;
    //
    //            document.dispatchEvent(deviceMotionEvent);
    //        };
    //    };

    // TODO WAIT IMPLEMENT
    // Window events (resize/pagehide/pageshow)
    //    var windowEvents = null;
    //
    //    var lifecycleEvent = {
    //        type: 'pagehide',
    //        target: window.document,
    //        currentTarget: window.document,
    //        timestamp: 0,
    //        preventDefault: function () {},
    //        stopPropagation: function () {}
    //    };
    //
    //    var resizeEvent = {
    //        type: 'resize',
    //        target: window,
    //        currentTarget: window,
    //        timestamp: 0,
    //        preventDefault: function () {},
    //        stopPropagation: function () {}
    //    };
    //
    //    var visibilityEvent = {
    //        type: 'visibilitychange',
    //        target: window.document,
    //        currentTarget: window.document,
    //        timestamp: 0,
    //        preventDefault: function () {},
    //        stopPropagation: function () {}
    //    };
    //
    //    eventInit.visibilitychange = eventInit.pagehide = eventInit.pageshow = eventInit.resize = function () {
    //        if (windowEvents) {
    //            return;
    //        }
    //
    //        windowEvents = new Ejecta.WindowEvents();
    //
    //        windowEvents.onpagehide = function () {
    //            document.hidden = true;
    //            document.visibilityState = 'hidden';
    //            visibilityEvent.timestamp = ej.performanceNow();
    //            document.dispatchEvent(visibilityEvent);
    //
    //            lifecycleEvent.type = 'pagehide';
    //            document.dispatchEvent(lifecycleEvent);
    //        };
    //
    //        windowEvents.onpageshow = function () {
    //            document.hidden = false;
    //            document.visibilityState = 'visible';
    //            visibilityEvent.timestamp = ej.performanceNow();
    //            document.dispatchEvent(visibilityEvent);
    //
    //            lifecycleEvent.type = 'pageshow';
    //            document.dispatchEvent(lifecycleEvent);
    //        };
    //
    //        windowEvents.onresize = function () {
    //            window.innerWidth = ej.screenWidth;
    //            window.innerHeight = ej.screenHeight;
    //            resizeEvent.timestamp = ej.performanceNow();
    //            document.dispatchEvent(resizeEvent);
    //        };
    //    };

    // TODO NOT IMPLEMENTED
    // Gamepad API
    //    var gamepadProvider = null;
    //    var initGamepadProvider = function () {
    //        if (gamepadProvider) {
    //            return;
    //        }
    //        gamepadProvider = new Ejecta.GamepadProvider();
    //
    //        gamepadProvider.ongamepadconnected = gamepadProvider.ongamepaddisconnected = function (ev) {
    //            document.dispatchEvent(ev);
    //        };
    //    };
    //
    //    navigator.getGamepads = function () {
    //        initGamepadProvider();
    //        return gamepadProvider.getGamepads();
    //    };
    //
    //    eventInit.gamepadconnected = eventInit.gamepaddisconnected = initGamepadProvider;
})(this);
