precision highp float;

attribute vec3 attPosition;
attribute vec2 attUV;

uniform int baseTexWidth;
uniform int baseTexHeight;

uniform vec2 inputTexSize;

varying vec2 uv0;

void main() {
	vec3 position = attPosition;
	float w = float(baseTexWidth);
	float h = float(baseTexHeight);

	if(inputTexSize.x * h > inputTexSize.y * w)
	{
		position.y *= (inputTexSize.y * w)/ (inputTexSize.x * h);
	}
	else
	{
		position.x *= (inputTexSize.x * h) / (inputTexSize.y * w);
	}

    gl_Position = vec4(position,1.0);
    uv0 = attUV.xy;
}
