(function (global) {
(function (factory) {
  typeof define === 'function' && define.amd ? define(factory) :
  factory();
}((function () { 'use strict';

  var ENVIRONMENT = "production";

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  var inspect = function () {
    function inspect(obj, opts) {
      var ctx = {
        seen: [],
        formatValueCalls: 0,
        stylize: stylizeNoColor
      };
      return formatValue(ctx, obj, opts.depth);
    }

    function stylizeNoColor(str, styleType) {
      return str;
    }

    function arrayToHash(array) {
      var hash = {};
      array.forEach(function (val, idx) {
        hash[val] = true;
      });
      return hash;
    }

    function formatValue(ctx, value, recurseTimes) {
      ctx.formatValueCalls++;

      if (ctx.formatValueCalls > 200) {
        return "[TOO BIG formatValueCalls ".concat(ctx.formatValueCalls, " exceeded limit of 200]");
      } // Primitive types cannot have properties


      var primitive = formatPrimitive(ctx, value);

      if (primitive) {
        return primitive;
      } // Look up the keys of the object.


      var keys = Object.keys(value);
      var visibleKeys = arrayToHash(keys); // IE doesn't make error fields non-enumerable
      // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx

      if (isError(value) && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
        return formatError(value);
      } // Some type of object without properties can be shortcutted.


      if (keys.length === 0) {
        if (isFunction(value)) {
          var name = value.name ? ': ' + value.name : '';
          return ctx.stylize('[Function' + name + ']', 'special');
        }

        if (isRegExp(value)) {
          return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
        }

        if (isDate(value)) {
          return ctx.stylize(Date.prototype.toString.call(value), 'date');
        }

        if (isError(value)) {
          return formatError(value);
        }
      }

      var base = '',
          array = false,
          braces = ['{', '}']; // Make Array say that they are Array

      if (isArray(value)) {
        array = true;
        braces = ['[', ']'];
      } // Make functions say that they are functions


      if (isFunction(value)) {
        var n = value.name ? ': ' + value.name : '';
        base = ' [Function' + n + ']';
      } // Make RegExps say that they are RegExps


      if (isRegExp(value)) {
        base = ' ' + RegExp.prototype.toString.call(value);
      } // Make dates with properties first say the date


      if (isDate(value)) {
        base = ' ' + Date.prototype.toUTCString.call(value);
      } // Make error with message first say the error


      if (isError(value)) {
        base = ' ' + formatError(value);
      }

      if (keys.length === 0 && (!array || value.length == 0)) {
        return braces[0] + base + braces[1];
      }

      if (recurseTimes < 0) {
        if (isRegExp(value)) {
          return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
        } else {
          return ctx.stylize('[Object]', 'special');
        }
      }

      ctx.seen.push(value);
      var output;

      if (array) {
        output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
      } else {
        output = keys.map(function (key) {
          return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
        });
      }

      ctx.seen.pop();
      return reduceToSingleString(output, base, braces);
    }

    function formatPrimitive(ctx, value) {
      if (isUndefined(value)) return ctx.stylize('undefined', 'undefined');

      if (isString(value)) {
        var simple = "'" + JSON.stringify(value).replace(/^"|"$/g, '').replace(/'/g, "\\'").replace(/\\"/g, '"') + "'";
        return ctx.stylize(simple, 'string');
      }

      if (isNumber(value)) return ctx.stylize('' + value, 'number');
      if (isBoolean(value)) return ctx.stylize('' + value, 'boolean'); // For some reason typeof null is "object", so special case here.

      if (isNull(value)) return ctx.stylize('null', 'null');
    }

    function formatError(value) {
      return '[' + Error.prototype.toString.call(value) + ']';
    }

    function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
      var output = [];

      for (var i = 0, l = value.length; i < l; ++i) {
        if (hasOwnProperty(value, String(i))) {
          output.push(formatProperty(ctx, value, recurseTimes, visibleKeys, String(i), true));
        } else {
          output.push('');
        }
      }

      keys.forEach(function (key) {
        if (!key.match(/^\d+$/)) {
          output.push(formatProperty(ctx, value, recurseTimes, visibleKeys, key, true));
        }
      });
      return output;
    }

    function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
      var name, str, desc;
      desc = Object.getOwnPropertyDescriptor(value, key) || {
        value: value[key]
      };

      if (desc.get) {
        if (desc.set) {
          str = ctx.stylize('[Getter/Setter]', 'special');
        } else {
          str = ctx.stylize('[Getter]', 'special');
        }
      } else {
        if (desc.set) {
          str = ctx.stylize('[Setter]', 'special');
        }
      }

      if (!hasOwnProperty(visibleKeys, key)) {
        name = '[' + key + ']';
      }

      if (!str) {
        if (ctx.seen.indexOf(desc.value) < 0) {
          if (isNull(recurseTimes)) {
            str = formatValue(ctx, desc.value, null);
          } else {
            str = formatValue(ctx, desc.value, recurseTimes - 1);
          }

          if (str.indexOf('\n') > -1) {
            if (array) {
              str = str.split('\n').map(function (line) {
                return '  ' + line;
              }).join('\n').substr(2);
            } else {
              str = '\n' + str.split('\n').map(function (line) {
                return '   ' + line;
              }).join('\n');
            }
          }
        } else {
          str = ctx.stylize('[Circular]', 'special');
        }
      }

      if (isUndefined(name)) {
        if (array && key.match(/^\d+$/)) {
          return str;
        }

        name = JSON.stringify('' + key);

        if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
          name = name.substr(1, name.length - 2);
          name = ctx.stylize(name, 'name');
        } else {
          name = name.replace(/'/g, "\\'").replace(/\\"/g, '"').replace(/(^"|"$)/g, "'");
          name = ctx.stylize(name, 'string');
        }
      }

      return name + ': ' + str;
    }

    function reduceToSingleString(output, base, braces) {
      var length = output.reduce(function (prev, cur) {
        if (cur.indexOf('\n') >= 0) ;
        return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
      }, 0);

      if (length > 60) {
        return braces[0] + (base === '' ? '' : base + '\n ') + ' ' + output.join(',\n  ') + ' ' + braces[1];
      }

      return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
    } // NOTE: These type checking functions intentionally don't use `instanceof`
    // because it is fragile and can be easily faked with `Object.create()`.


    function isArray(ar) {
      return Array.isArray(ar);
    }

    function isBoolean(arg) {
      return typeof arg === 'boolean';
    }

    function isNull(arg) {
      return arg === null;
    }

    function isNumber(arg) {
      return typeof arg === 'number';
    }

    function isString(arg) {
      return typeof arg === 'string';
    }

    function isUndefined(arg) {
      return arg === void 0;
    }

    function isRegExp(re) {
      return isObject(re) && objectToString(re) === '[object RegExp]';
    }

    function isObject(arg) {
      return _typeof(arg) === 'object' && arg !== null;
    }

    function isDate(d) {
      return isObject(d) && objectToString(d) === '[object Date]';
    }

    function isError(e) {
      return isObject(e) && (objectToString(e) === '[object Error]' || e instanceof Error);
    }

    function isFunction(arg) {
      return typeof arg === 'function';
    }

    function objectToString(o) {
      return Object.prototype.toString.call(o);
    }

    function hasOwnProperty(obj, prop) {
      return Object.prototype.hasOwnProperty.call(obj, prop);
    }

    return inspect;
  }();

  var OBJECT_COLUMN_NAME = '(index)';
  var LOG_LEVELS = {
    trace: 0,
    info: 1,
    warn: 2,
    error: 3
  };
  var INSPECTOR_LEVELS = [];
  INSPECTOR_LEVELS[LOG_LEVELS.trace] = 'debug';
  INSPECTOR_LEVELS[LOG_LEVELS.info] = 'log';
  INSPECTOR_LEVELS[LOG_LEVELS.warn] = 'warning';
  INSPECTOR_LEVELS[LOG_LEVELS.error] = 'error'; // Strip the inner function in getNativeLogFunction(), if in dev also
  // strip method printing to originalConsole.

  var INSPECTOR_FRAMES_TO_SKIP = 1;

  function getNativeLogFunction(level) {
    return function () {
      var str;

      if (arguments.length === 1 && typeof arguments[0] === 'string') {
        str = arguments[0];
      } else {
        str = Array.prototype.map.call(arguments, function (arg) {
          return inspect(arg, {
            depth: 10
          });
        }).join(', ');
      }

      var logLevel = level;

      if (str.slice(0, 9) === 'Warning: ' && logLevel >= LOG_LEVELS.error) {
        // React warnings use console.error so that a stack trace is shown,
        // but we don't (currently) want these to show a redbox
        // (Note: Logic duplicated in ExceptionsManager.js.)
        logLevel = LOG_LEVELS.warn;
      }

      if (commonjsGlobal.__inspectorLog) {
        commonjsGlobal.__inspectorLog(INSPECTOR_LEVELS[logLevel], str, [].slice.call(arguments), INSPECTOR_FRAMES_TO_SKIP);
      }

      if (groupStack.length) {
        str = groupFormat('', str);
      }

      commonjsGlobal.nativeLoggingHook(str, logLevel);
    };
  }

  function repeat(element, n) {
    return Array.apply(null, Array(n)).map(function () {
      return element;
    });
  }

  function consoleTablePolyfill(rows) {
    // convert object -> array
    if (!Array.isArray(rows)) {
      var data = rows;
      rows = [];

      for (var key in data) {
        if (data.hasOwnProperty(key)) {
          var row = data[key];
          row[OBJECT_COLUMN_NAME] = key;
          rows.push(row);
        }
      }
    }

    if (rows.length === 0) {
      commonjsGlobal.nativeLoggingHook('', LOG_LEVELS.info);
      return;
    }

    var columns = Object.keys(rows[0]).sort();
    var stringRows = [];
    var columnWidths = []; // Convert each cell to a string. Also
    // figure out max cell width for each column

    columns.forEach(function (k, i) {
      columnWidths[i] = k.length;

      for (var j = 0; j < rows.length; j++) {
        var cellStr = (rows[j][k] || '?').toString();
        stringRows[j] = stringRows[j] || [];
        stringRows[j][i] = cellStr;
        columnWidths[i] = Math.max(columnWidths[i], cellStr.length);
      }
    }); // Join all elements in the row into a single string with | separators
    // (appends extra spaces to each cell to make separators  | aligned)

    function joinRow(row, space) {
      var cells = row.map(function (cell, i) {
        var extraSpaces = repeat(' ', columnWidths[i] - cell.length).join('');
        return cell + extraSpaces;
      });
      space = space || ' ';
      return cells.join(space + '|' + space);
    }

    var separators = columnWidths.map(function (columnWidth) {
      return repeat('-', columnWidth).join('');
    });
    var separatorRow = joinRow(separators, '-');
    var header = joinRow(columns);
    var table = [header, separatorRow];

    for (var i = 0; i < rows.length; i++) {
      table.push(joinRow(stringRows[i]));
    } // Notice extra empty line at the beginning.
    // Native logging hook adds "RCTLog >" at the front of every
    // logged string, which would shift the header and screw up
    // the table


    commonjsGlobal.nativeLoggingHook('\n' + table.join('\n'), LOG_LEVELS.info);
  }

  var GROUP_PAD = "\u2502"; // Box light vertical

  var GROUP_OPEN = "\u2510"; // Box light down+left

  var GROUP_CLOSE = "\u2518"; // Box light up+left

  var groupStack = [];

  function groupFormat(prefix, msg) {
    // Insert group formatting before the console message
    return groupStack.join('') + prefix + ' ' + (msg || '');
  }

  function consoleGroupPolyfill(label) {
    commonjsGlobal.nativeLoggingHook(groupFormat(GROUP_OPEN, label), LOG_LEVELS.info);
    groupStack.push(GROUP_PAD);
  }

  function consoleGroupCollapsedPolyfill(label) {
    commonjsGlobal.nativeLoggingHook(groupFormat(GROUP_CLOSE, label), LOG_LEVELS.info);
    groupStack.push(GROUP_PAD);
  }

  function consoleGroupEndPolyfill() {
    groupStack.pop();
    commonjsGlobal.nativeLoggingHook(groupFormat(GROUP_CLOSE), LOG_LEVELS.info);
  }

  function consoleAssertPolyfill(expression, label) {
    if (!expression) {
      commonjsGlobal.nativeLoggingHook('Assertion failed: ' + label, LOG_LEVELS.error);
    }
  }

  if (commonjsGlobal.nativeLoggingHook) {
    commonjsGlobal.console; // Preserve the original `console` as `originalConsole`

    commonjsGlobal.console = {
      error: getNativeLogFunction(LOG_LEVELS.error),
      info: getNativeLogFunction(LOG_LEVELS.info),
      log: getNativeLogFunction(LOG_LEVELS.info),
      warn: getNativeLogFunction(LOG_LEVELS.warn),
      trace: getNativeLogFunction(LOG_LEVELS.trace),
      debug: getNativeLogFunction(LOG_LEVELS.trace),
      table: consoleTablePolyfill,
      group: consoleGroupPolyfill,
      groupEnd: consoleGroupEndPolyfill,
      groupCollapsed: consoleGroupCollapsedPolyfill,
      assert: consoleAssertPolyfill
    };
    Object.defineProperty(console, '_isPolyfilled', {
      value: true,
      enumerable: false
    });

    if (!commonjsGlobal.console) {
      var log = commonjsGlobal.print || function consoleLoggingStub() {};

      commonjsGlobal.console = {
        error: log,
        info: log,
        log: log,
        warn: log,
        trace: log,
        debug: log,
        table: log
      };
      Object.defineProperty(console, '_isPolyfilled', {
        value: true,
        enumerable: false
      });
    }
  }

  function noop() {} // States:
  //
  // 0 - pending
  // 1 - fulfilled with _value
  // 2 - rejected with _value
  // 3 - adopted the state of another promise, _value
  //
  // once the state is no longer pending (0) it is immutable
  // All `_` prefixed properties will be reduced to `_{random number}`
  // at build time to obfuscate them and discourage their use.
  // We don't use symbols or Object.defineProperty to fully hide them
  // because the performance isn't good enough.
  // to avoid using try/catch inside critical functions, we
  // extract them to here.


  var LAST_ERROR = null;
  var IS_ERROR = {};

  function getThen(obj) {
    try {
      return obj.then;
    } catch (ex) {
      LAST_ERROR = ex;
      return IS_ERROR;
    }
  }

  function tryCallOne(fn, a) {
    try {
      return fn(a);
    } catch (ex) {
      LAST_ERROR = ex;
      return IS_ERROR;
    }
  }

  function tryCallTwo(fn, a, b) {
    try {
      fn(a, b);
    } catch (ex) {
      LAST_ERROR = ex;
      return IS_ERROR;
    }
  }

  var core = Promise$1;

  function Promise$1(fn) {
    if (_typeof(this) !== 'object') {
      throw new TypeError('Promises must be constructed via new');
    }

    if (typeof fn !== 'function') {
      throw new TypeError('Promise constructor\'s argument is not a function');
    }

    this._U = 0;
    this._V = 0;
    this._W = null;
    this._X = null;
    if (fn === noop) return;
    doResolve(fn, this);
  }

  Promise$1._Y = null;
  Promise$1._Z = null;
  Promise$1._0 = noop;

  Promise$1.prototype.then = function (onFulfilled, onRejected) {
    if (this.constructor !== Promise$1) {
      return safeThen(this, onFulfilled, onRejected);
    }

    var res = new Promise$1(noop);
    handle(this, new Handler(onFulfilled, onRejected, res));
    return res;
  };

  function safeThen(self, onFulfilled, onRejected) {
    return new self.constructor(function (resolve, reject) {
      var res = new Promise$1(noop);
      res.then(resolve, reject);
      handle(self, new Handler(onFulfilled, onRejected, res));
    });
  }

  function handle(self, deferred) {
    while (self._V === 3) {
      self = self._W;
    }

    if (Promise$1._Y) {
      Promise$1._Y(self);
    }

    if (self._V === 0) {
      if (self._U === 0) {
        self._U = 1;
        self._X = deferred;
        return;
      }

      if (self._U === 1) {
        self._U = 2;
        self._X = [self._X, deferred];
        return;
      }

      self._X.push(deferred);

      return;
    }

    handleResolved(self, deferred);
  }

  function handleResolved(self, deferred) {
    setImmediate(function () {
      var cb = self._V === 1 ? deferred.onFulfilled : deferred.onRejected;

      if (cb === null) {
        if (self._V === 1) {
          resolve(deferred.promise, self._W);
        } else {
          reject(deferred.promise, self._W);
        }

        return;
      }

      var ret = tryCallOne(cb, self._W);

      if (ret === IS_ERROR) {
        reject(deferred.promise, LAST_ERROR);
      } else {
        resolve(deferred.promise, ret);
      }
    });
  }

  function resolve(self, newValue) {
    // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
    if (newValue === self) {
      return reject(self, new TypeError('A promise cannot be resolved with itself.'));
    }

    if (newValue && (_typeof(newValue) === 'object' || typeof newValue === 'function')) {
      var then = getThen(newValue);

      if (then === IS_ERROR) {
        return reject(self, LAST_ERROR);
      }

      if (then === self.then && newValue instanceof Promise$1) {
        self._V = 3;
        self._W = newValue;
        finale(self);
        return;
      } else if (typeof then === 'function') {
        doResolve(then.bind(newValue), self);
        return;
      }
    }

    self._V = 1;
    self._W = newValue;
    finale(self);
  }

  function reject(self, newValue) {
    self._V = 2;
    self._W = newValue;

    if (Promise$1._Z) {
      Promise$1._Z(self, newValue);
    }

    finale(self);
  }

  function finale(self) {
    if (self._U === 1) {
      handle(self, self._X);
      self._X = null;
    }

    if (self._U === 2) {
      for (var i = 0; i < self._X.length; i++) {
        handle(self, self._X[i]);
      }

      self._X = null;
    }
  }

  function Handler(onFulfilled, onRejected, promise) {
    this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
    this.onRejected = typeof onRejected === 'function' ? onRejected : null;
    this.promise = promise;
  }
  /**
   * Take a potentially misbehaving resolver function and make sure
   * onFulfilled and onRejected are only called once.
   *
   * Makes no guarantees about asynchrony.
   */


  function doResolve(fn, promise) {
    var done = false;
    var res = tryCallTwo(fn, function (value) {
      if (done) return;
      done = true;
      resolve(promise, value);
    }, function (reason) {
      if (done) return;
      done = true;
      reject(promise, reason);
    });

    if (!done && res === IS_ERROR) {
      done = true;
      reject(promise, LAST_ERROR);
    }
  }

  var es6Extensions = core;
  /* Static Functions */

  var TRUE = valuePromise(true);
  var FALSE = valuePromise(false);
  var NULL = valuePromise(null);
  var UNDEFINED = valuePromise(undefined);
  var ZERO = valuePromise(0);
  var EMPTYSTRING = valuePromise('');

  function valuePromise(value) {
    var p = new core(core._0);
    p._V = 1;
    p._W = value;
    return p;
  }

  core.resolve = function (value) {
    if (value instanceof core) return value;
    if (value === null) return NULL;
    if (value === undefined) return UNDEFINED;
    if (value === true) return TRUE;
    if (value === false) return FALSE;
    if (value === 0) return ZERO;
    if (value === '') return EMPTYSTRING;

    if (_typeof(value) === 'object' || typeof value === 'function') {
      try {
        var then = value.then;

        if (typeof then === 'function') {
          return new core(then.bind(value));
        }
      } catch (ex) {
        return new core(function (resolve, reject) {
          reject(ex);
        });
      }
    }

    return valuePromise(value);
  };

  var _iterableToArray = function iterableToArray(iterable) {
    if (typeof Array.from === 'function') {
      // ES2015+, iterables exist
      _iterableToArray = Array.from;
      return Array.from(iterable);
    } // ES5, only arrays and array-likes exist


    _iterableToArray = function iterableToArray(x) {
      return Array.prototype.slice.call(x);
    };

    return Array.prototype.slice.call(iterable);
  };

  core.all = function (arr) {
    var args = _iterableToArray(arr);

    return new core(function (resolve, reject) {
      if (args.length === 0) return resolve([]);
      var remaining = args.length;

      function res(i, val) {
        if (val && (_typeof(val) === 'object' || typeof val === 'function')) {
          if (val instanceof core && val.then === core.prototype.then) {
            while (val._V === 3) {
              val = val._W;
            }

            if (val._V === 1) return res(i, val._W);
            if (val._V === 2) reject(val._W);
            val.then(function (val) {
              res(i, val);
            }, reject);
            return;
          } else {
            var then = val.then;

            if (typeof then === 'function') {
              var p = new core(then.bind(val));
              p.then(function (val) {
                res(i, val);
              }, reject);
              return;
            }
          }
        }

        args[i] = val;

        if (--remaining === 0) {
          resolve(args);
        }
      }

      for (var i = 0; i < args.length; i++) {
        res(i, args[i]);
      }
    });
  };

  core.reject = function (value) {
    return new core(function (resolve, reject) {
      reject(value);
    });
  };

  core.race = function (values) {
    return new core(function (resolve, reject) {
      _iterableToArray(values).forEach(function (value) {
        core.resolve(value).then(resolve, reject);
      });
    });
  };
  /* Prototype Methods */


  core.prototype['catch'] = function (onRejected) {
    return this.then(null, onRejected);
  };

  global.Promise = es6Extensions;

  var MessageQueue = /*#__PURE__*/function () {
    function MessageQueue() {
      _classCallCheck(this, MessageQueue);

      this._lazyCallableModules = {};
      this.callFunction = this.callFunction.bind(this);
    }

    _createClass(MessageQueue, [{
      key: "callFunction",
      value: function callFunction(module, method, args, callback) {
        console.log("card-tpl", module + "," + method);
        var moduleMethods = this.getCallableModule(module);
        var result = moduleMethods[method].apply(moduleMethods, args);
        callback && callback(result);
      }
    }, {
      key: "registerCallableModule",
      value: function registerCallableModule(name, module) {
        this._lazyCallableModules[name] = function () {
          return module;
        };
      }
    }, {
      key: "getCallableModule",
      value: function getCallableModule(name) {
        var getValue = this._lazyCallableModules[name];
        return getValue ? getValue() : null;
      }
    }]);

    return MessageQueue;
  }();

  var messageQueue = new MessageQueue();
  var callFunction = function callFunction(params, callback) {
    if (params.length < 2) {
      console.error("callFunction params length < 2");
      return;
    }

    var len = params.length;
    var method = params[len - 1];
    var module = params[len - 2];
    params.splice(len - 2, 2);
    messageQueue.callFunction(module, method, params, callback);
  };
  Object.defineProperty(global, '__bridge', {
    configurable: true,
    value: callFunction
  });
  Object.defineProperty(global, 'BatchedBridge', {
    configurable: true,
    value: messageQueue
  });

})));
})(this)