utils = { _version = "0.1.0" }

local ge_feature_name = "Animation/"
utils.anim_pass_name = "anim"

utils.ANIM_ENTER = 'enter'
utils.ANIM_EXIT = 'exit'
utils.ANIM_LOOP = 'loop'

function utils.deepCopy(orig)
    local copy
    if type(orig) == "table" then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[utils.deepCopy(orig_key)] = utils.deepCopy(orig_value)
        end
        setmetatable(copy, utils.deepCopy(getmetatable(orig)))
    else
        copy = orig
    end
    return copy
end

function utils.removeSpaceChars(chars)
    local noSpaceChars = {}
    local spaceChars = {}

    local charCount = #chars;
    for i = 1, charCount do
        local c = chars[i]
        local code = c["unicode"]

        if code == ' ' or code == '\r' or code == '\n' then
            local space = {}
            space.index = i
            space.char = code
            spaceChars[#spaceChars + 1] = space
        else
            noSpaceChars[#noSpaceChars + 1] = utils.deepCopy(c);
        end
    end
    return noSpaceChars, spaceChars
end

function utils.updateChars(textFeature, value)
    local resTable = { chars = value }
    local jsonStr = json.encode(resTable);
    textFeature:command("update_chars", jsonStr);
end

function utils.updateDrawable(textFeature, value)
    local resTable = { drawOptions = value }
    local jsonStr = json.encode(resTable);
    textFeature:command("set_properties", jsonStr);
end

function utils.randomArray(length)
    if length and length > 0 then
        local array = {}
        for i = 1, length do
            table.insert(array, i)
        end
        calc.randomSeed()
        local length = #array
        local randArray = {}
        for i = 1, length do
            local index = math.random(1, #array)
            table.insert(randArray, array[index])
            table.remove(array, index)
        end
        return randArray
    end
    return {}
end

function utils.calcTime(config, milliSeconds, loop)
    if config.duration <= 0 then
        return -1
    else
        config.time = milliSeconds
        if config["total_duration"] then
            if config.type == utils.ANIM_ENTER then
                --入场
            elseif config.type == utils.ANIM_EXIT then
                --出场
                config.time = config.time - (config["total_duration"] - config.duration)
            end
        end
        if loop then
            config.time = math.fmod(config.time, config.duration)
        end
        return config.time / config.duration;
    end
end

function utils.getFeature(this)
    local renderFeature = this:getFeature(ge_feature_name)
    if not renderFeature then
        return
    end
    return EffectSdk.castGeneralEffectFeature(renderFeature)
end

function utils.initConfig(this, self)
    self.screenSize = { 1, 1 }
    self.radio = 1

    local effectMgr = this:getEffectManager()
    self.screenSize = { effectMgr:getInputWidth(), effectMgr:getInputHeight() }
    self.radio = self.screenSize[1] / self.screenSize[2]
end

function utils.updateConfig(self, jsonStr)
    local userConfig = json.decode(jsonStr)
    if userConfig then
        if userConfig["color"] then
            self.color = { userConfig["color"]["r"], userConfig["color"]["g"],
                           userConfig["color"]["b"], userConfig["color"]["a"] }
        end
        if userConfig["video"] then
            self.hasVideo = 1
            if userConfig["video"]["blur"] then
                self.videoBlur = userConfig["video"]["blur"]
            end
            if userConfig["video"]["rotation"] then
                self.videoRotation = userConfig["video"]["rotation"]
            end
            if userConfig["video"]["alpha"] then
                self.videoAlpha = userConfig["video"]["alpha"]
            end
        end
        if userConfig["image"] and userConfig["image"]["path"] then
            self.hasImage = 1
            self.imagePath = userConfig["image"]["path"]
            if userConfig["image"]["alpha"] then
                self.imageAlpha = userConfig["image"]["alpha"]
            end
            if userConfig["image"]["blur"] then
                self.imageBlur = userConfig["image"]["blur"]
            end
        end
    end
end

function utils.initMat(self)
    local initScaleMat = SDKTool.scaleMat({ 1, self.radio, 1 })
    local rotationMat = SDKTool.rotateMat({ 0, 0, self.rotation })

    local translateMat = SDKTool.translateMat({ self.translate[1], self.translate[2], 0 })

    local scaleMat = SDKTool.scaleMat(self.scale)

    local mat = SDKTool.modelMat()
    mat = SDKTool.multiplyMats(mat, translateMat)
    mat = SDKTool.multiplyMats(mat, scaleMat)
    mat = SDKTool.multiplyMats(mat, initScaleMat, rotationMat, SDKTool.inverseMat(initScaleMat))
    return mat
end

function utils.adjustRadio(p, radio)
    if p and p[1] and p[2] then
        if radio > 1 then
            return { p[1] * radio, p[2] }
        else
            return { p[1], p[2] / radio }
        end
    else
        return p
    end
end