calc = { _version = "0.1.0" }

function calc.randomSeed()
    math.randomseed(tostring(os.time()):reverse():sub(1, 6))
end

-- 随机函数
function calc.random()
    calc.randomSeed()
    return math.random()
end

function calc.randomRange(a, b)
    calc.randomSeed()
    return math.random(a, b)
end

-- angle 此处传入角度
function calc.angleToRadian(angle)
    return math.rad(angle)
end

-- radian 此处传入弧度
function calc.radianToAngle(radian)
    return math.deg(radian)
end

-- 此处返回角度
function calc.calcVVAngle(v1, v2)
    if v1 and v1[1] and v1[2] and v2 and v2[1] and v2[2] then
        local l1 = math.sqrt(v1[1] * v1[1] + v1[2] * v1[2])
        local l2 = math.sqrt(v2[1] * v2[1] + v2[2] * v2[2])
        local v1v2 = v1[1] * v2[1] + v1[2] * v2[1]
        local result = v1v2 / (l1 * l2)
        return calc.radianToAngle(math.acos(result))
    end
end

-- angle 此处传入弧度
function calc.rotateV(v, angle)
    if (not v and not v[1] and not v[2] and not angle) then
        return { 0, 0 }
    else
        return { v[1] * math.cos(angle) - v[2] * math.sin(angle), v[1] * math.sin(angle) + v[2] * math.cos(angle) }
    end
end

function calc.rotateVY(v, angle)
    if (not v and not v[1] and not v[2] and not angle) then
        return { 0, 0 }
    else
        return { v[1] * math.cos(angle) - v[2] * math.sin(angle), v[1] * math.sin(angle) + v[2] * math.cos(angle) }
    end
end

function calc.normalV(v)
    if (v and v[1] and v[2]) then
        local l = math.sqrt(v[1] * v[1] + v[2] * v[2])
        return { v[1] / l, v[2] / l }
    end
    return v
end

function calc.lengthV(v)
    if (v and v[1] and v[2]) then
        return math.sqrt(v[1] * v[1] + v[2] * v[2])
    end
    return 0
end

function calc.distanceVV(v1, v2)
    if (v1 and v1[1] and v1[2] and v2 and v2[1] and v2[2]) then
        return math.sqrt((v1[1] - v2[1]) * (v1[1] - v2[1]) + (v1[2] - v2[2]) * (v1[2] - v2[2]))
    end
    return 0
end

function calc.addVV(v1, v2)
    local i = 1
    local resVec = {}
    if v1 and v2 then
        while v1[i] and v2[i] do
            resVec[i] = v1[i] + v2[i]
            i = i + 1
        end
    end
    return resVec
end

function calc.subVV(v1, v2)
    local i = 1
    local resVec = {}
    if v1 and v2 then
        while v1[i] and v2[i] do
            resVec[i] = v1[i] - v2[i]
            i = i + 1
        end
    end
    return resVec
end

function calc.multiplyVV(v1, v2)
    local i = 1
    local resVec = {}
    if v1 and v2 then
        while v1[i] and v2[i] do
            resVec[i] = v1[i] * v2[i]
            i = i + 1
        end
    end
    return resVec
end

function calc.divideVV(v1, v2)
    local i = 1
    local resVec = {}
    if v1 and v2 then
        while v1[i] and v2[i] do
            resVec[i] = v1[i] / v2[i]
            i = i + 1
        end
    end
    return resVec
end

function calc.addV(v, value)
    local i = 1
    local resVec = {}
    if v and value then
        while v[i] do
            resVec[i] = v[i] + value
            i = i + 1
        end
    end
    return resVec
end

function calc.multiplyV(v, value)
    local i = 1
    local resVec = {}
    if v and value then
        while v[i] do
            resVec[i] = v[i] * value
            i = i + 1
        end
    end
    return resVec
end

-- x 的 y 次方(只支持正整数的y)
function calc.pow(x, y)
    if x and y then
        return x ^ y
    end
    return x
end

function calc.east(t, m)
    if not m then
        m = 1
    end
    if t then
        t = math.max(math.min(t, 1), 0)
        return calc.pow(t, m)
    end
    return t
end

-- 端点略有收回(BackEase)
-- BackEaseIn
function calc.backEaseIn(t)
    if t then
        return calc.pow(t, 3) - 0.3 * t * math.sin(t * math.pi)
    end
    return t
end

-- BackEaseOut
function calc.backEaseOut(t)
    return calc.customBackEaseOut(t, 3, 0.3)
end

function calc.customBackEaseOut(t, m, n)
    if t then
        t = 1 - t
        return 1 - (calc.pow(t, m) - n * t * math.sin(t * math.pi))
    end
    return t
end

---- 振荡(ElasticEase)
---- ElasticEaseIn
function calc.elasticEaseIn(t)
    if t then
        return calc.pow(100, t) * math.sin(4.5 * math.pi * t) / 100
    end
    return t
end

-- ElasticEaseOut
function calc.elasticEaseOut(t)
    return calc.customElasticEaseOut(t, 4.5)
end

function calc.customElasticEaseOut(t, n)
    if t then
        t = 1 - t
        return 1 - (calc.pow(100, t) * math.sin(n * math.pi * t) / 100)
    end
    return t
end