SDKTool = { _version = "0.1.0" }

function SDKTool.vec2(v)
    return EffectSdk.Vec2(v[1], v[2])
end

function SDKTool.vec3(v)
    return EffectSdk.Vec3(v[1], v[2], v[3])
end

-- 该方法都是默认四阶矩阵
function SDKTool.modelMat()
    local c1 = EffectSdk.Vec4(1.0, 0.0, 0.0, 0.0)
    local c2 = EffectSdk.Vec4(0.0, 1.0, 0.0, 0.0)
    local c3 = EffectSdk.Vec4(0.0, 0.0, 1.0, 0.0)
    local c4 = EffectSdk.Vec4(0.0, 0.0, 0.0, 1.0)
    return EffectSdk.Mat4(c1, c2, c3, c4)
end

-- angle为角度
function SDKTool.rotateMat(rotation)
    local axisX = EffectSdk.Vec3(1.0, 0.0, 0.0);
    local xMat = EffectSdk.Math.rotate(calc.angleToRadian(rotation[1]), axisX);
    local axisY = EffectSdk.Vec3(0.0, 1.0, 0.0);
    local yMat = EffectSdk.Math.rotate(calc.angleToRadian(rotation[2]), axisY);
    local axisZ = EffectSdk.Vec3(0.0, 0.0, 1.0);
    local zMat = EffectSdk.Math.rotate(calc.angleToRadian(rotation[3]), axisZ);
    return SDKTool.multiplyMM(SDKTool.multiplyMM(xMat, yMat), zMat)
end

function SDKTool.translateMat(translate)
    return EffectSdk.Math.translate(EffectSdk.Vec3(translate[1], translate[2], translate[3]))
end

function SDKTool.scaleMat(scale)
    return EffectSdk.Math.scale(EffectSdk.Vec3(scale[1], scale[2], scale[3]))
end

function SDKTool.inverseMat(mat)
    return EffectSdk.Math.inverseMat4(mat)
end

function SDKTool.multiplyMM(mat1, mat2)
    if mat1 and mat2 then
        return EffectSdk.Math.multiplyMat4Mat4(mat1, mat2)
    else
        return mat1
    end
end

function SDKTool.multiplyMats(...)
    local mat = SDKTool.modelMat()
    local mats = { ... }
    for k, v in pairs(mats) do
        mat = SDKTool.multiplyMM(mat, v)
    end
    return mat
end

function SDKTool.multiplyMV(mat, v)
    if mat and v then
        return EffectSdk.Math.multiplyMat4Vec4(mat, v)
    else
        return v
    end
end

function SDKTool.multiplyM(mat, num)
    if mat and num then
        return EffectSdk.Math.multiplyVec4Num(mat, num)
    else
        return mat
    end
end

function SDKTool.matToVector(mat)
    local v = EffectSdk.vectorf()
    for i = 1, 16 do
        local x = math.fmod(i - 1, 4)
        local y = math.floor((i - 1) / 4)
        local value = EffectSdk.Mat4.getElement(mat, y, x)
        v:push_back(value)
    end
    return v
end

function SDKTool.printMat(mat)
    local arr = {}
    for i = 0, 3 do
        for j = 0, 3 do
            arr[i * 4 + j] = EffectSdk.Mat4.getElement(mat, i, j)
        end
    end

    log.e(string.format("%f %f %f %f\n%f %f %f %f\n%f %f %f %f\n%f %f %f %f", arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8], arr[9], arr[10], arr[11], arr[12], arr[13], arr[14], arr[15]))
end

function SDKTool.setInt(feature, key, value, passName)
    feature:setUniformInt(passName, 2, key, value)
end

function SDKTool.setFloat(feature, key, value, passName)
    feature:setUniformFloat(passName, 3, key, value)
end

function SDKTool.setVec2(feature, key, v, passName)
    feature:setUniformVec2(passName, 4, key, v)
end

function SDKTool.setVec3(feature, key, v, passName)
    feature:setUniformVec3(passName, 5, key, v)
end

function SDKTool.setVec4(feature, key, v, passName)
    feature:setUniformVec4(passName, 6, key, v)
end

function SDKTool.setMat(feature, mat, passName)
    local resMat = SDKTool.matToVector(mat)
    feature:setUniformMat4(passName, 8, "MVPMatrix", resMat)
end

function SDKTool.getScreenSize(this)
    local effectMgr = this:getEffectManager()
    return { effectMgr:getInputWidth(), effectMgr:getInputHeight() }
end