local Animation = {}
function Animation:new()
    local anim = {}
    setmetatable(anim, self)
    self.__index = self
    self.startTime = 0

    self.color = nil
    --  1 外部图片 2 纯色背景 3 原始视频纹理
    self.inputType = 3
    self.image = nil
    self.intensity = 0
    self.alpha = 1
    self.rotation = 0

    return anim
end

local self = Animation:new()

local PASS_TRANSFORM = "transform"
local PASS_TRANSFORM2 = "transform2"
local PASS_BLUR_H = "blur_h"
local PASS_BLUR_V = "blur_v"
local PASS_MERGE = "merge"
local PASS_RESULT = "result"

EventHandles = {
    handleEffectEvent = function(this, eventCode)
    end,

    handleUserEvent = function(this, json_string)
        self.color = { 0.0, 0.0, 0.0, 1.0 }

        self.hasImage = 0
        self.imagePath = nil
        self.imageBlur = 0
        self.imageAlpha = 1

        self.hasVideo = 0
        self.videoBlur = 0
        self.videoAlpha = 1
        self.videoRotation = 0

        utils.updateConfig(self, json_string)

        local geFeature = utils.getFeature(this)
        if geFeature == nil then
            return
        end

        log.e(json.encode(self))

        local bgColor = EffectSdk.vectorf()
        bgColor:push_back(self.color[1])
        bgColor:push_back(self.color[2])
        bgColor:push_back(self.color[3])
        bgColor:push_back(self.color[4])
        if self.hasVideo == 1 then
            geFeature:setElementEnable(PASS_TRANSFORM, true)
            SDKTool.setFloat(geFeature, "angle", calc.angleToRadian(self.videoRotation), PASS_TRANSFORM)
        else
            geFeature:setElementEnable(PASS_TRANSFORM, true)
        end

        if self.hasImage == 1 and self.imagePath and this:loadTexture("", self.imagePath, "inputImage") then
            this:bindInputTexture("inputImage", 10)
            geFeature:setElementEnable(PASS_TRANSFORM2, true)
        else
            geFeature:setElementEnable(PASS_TRANSFORM2, false)
        end

        -- self.videoAlpha = 0.5
        -- self.videoBlur = 0
        -- self.hasVideo = 0
        -- self.imageBlur = 1
        -- self.imageAlpha = 0.5
        -- self.videoRotation = 20.0
        SDKTool.setVec4(geFeature, "bgColor", bgColor, PASS_MERGE)
        SDKTool.setInt(geFeature, "hasVideo", self.hasVideo, PASS_MERGE)
        SDKTool.setInt(geFeature, "hasImage", self.hasImage, PASS_MERGE)
        SDKTool.setFloat(geFeature, "imageAlpha", self.imageAlpha, PASS_MERGE)
        SDKTool.setFloat(geFeature, "videoAlpha", self.videoAlpha, PASS_MERGE)

        if self.imageBlur == 0 and self.videoBlur == 0 then
            self.hasBlur = 0
            geFeature:setElementEnable(PASS_BLUR_H, false)
            geFeature:setElementEnable(PASS_BLUR_V, false)
        else
            self.hasBlur = 1
            geFeature:setElementEnable(PASS_BLUR_H, true)
            geFeature:setElementEnable(PASS_BLUR_V, true)
            local intensity = self.videoBlur == 0 and self.imageBlur or self.videoBlur

            SDKTool.setFloat(geFeature, "intensity", intensity, PASS_BLUR_H)
            SDKTool.setFloat(geFeature, "intensity", intensity, PASS_BLUR_V)
            SDKTool.setFloat(geFeature, "alpha", self.videoAlpha, PASS_BLUR_V)
        end

        SDKTool.setInt(geFeature, "hasBlur", self.hasBlur, PASS_RESULT)
        SDKTool.setVec4(geFeature, "bgColor", bgColor, PASS_RESULT)
    end,

    handleUpdate = function(this, milliSeconds)
        local geFeature = utils.getFeature(this)
        if geFeature == nil then
            return
        end
        utils.initConfig(this, self)

        if self.hasVideo == 1 then
            local initScale = { 1, self.radio, 1 }
            local initScaleMat = SDKTool.scaleMat(initScale)
            local rotationMat = SDKTool.rotateMat({ 0, 0, self.videoRotation })
            local mat = SDKTool.multiplyMats(initScaleMat, rotationMat, SDKTool.inverseMat(initScaleMat))
            SDKTool.setMat(geFeature, mat, PASS_TRANSFORM)
        end
    end
}