precision mediump float;

attribute vec4 attPosition;
attribute vec2 attUV;

uniform mat4 MVPMatrix;
uniform int imageWidth;
uniform int imageHeight;
uniform vec2 imageSize;
uniform float angle;

varying vec2 uv;

void main() {
    float dRadioX = 1.0;
    float dRadioY = 1.0;
    vec2 box = vec2(float(imageWidth), float(imageHeight));
    float dRadio = (imageSize.x / imageSize.y) / (box.x / box.y);
    if (dRadio < 1.0){
        dRadioY = 1.0 / dRadio;
    } else {
        dRadioX = dRadio;
    }

    mat4 scaleMat = mat4(
    dRadioX, 0.0, 0.0, 0.0,
    0.0, dRadioY, 0.0, 0.0,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0);

    gl_Position = MVPMatrix * scaleMat * attPosition;
    uv = attUV;
}