precision mediump float;

attribute vec4 attPosition;
attribute vec2 attUV;

uniform mat4 MVPMatrix;
uniform int imageWidth;
uniform int imageHeight;
uniform float angle;

varying vec2 uv;

void main() {
    float scaleRect = 1.0;
    vec2 box = vec2(float(imageWidth), float(imageHeight));

    float boxFrameW = box.x * abs(cos(angle)) + box.y * abs(sin(angle));
    float boxFrameH = box.y * abs(cos(angle)) + box.x * abs(sin(angle));

    float scaleX = boxFrameW / box.x;
    float scaleY = boxFrameH / box.y;
    if (scaleX > scaleY){
        scaleRect = scaleX;
    } else {
        scaleRect = scaleY;
    }

    mat4 scaleMat = mat4(
    scaleRect, 0.0, 0.0, 0.0,
    0.0, scaleRect, 0.0, 0.0,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0);

    gl_Position = MVPMatrix * scaleMat * attPosition;
    uv = attUV;
}