precision mediump float;

uniform sampler2D inputTexture;
uniform sampler2D inputTextureTrans;
uniform sampler2D inputTextureReal;
uniform vec4 bgColor;
uniform int hasBlur;

varying vec2 uv;

void main()
{
    vec4 textureBg = vec4(0);
    if (hasBlur == 1){
        textureBg = texture2D(inputTexture, uv);
    } else {
        textureBg = texture2D(inputTextureTrans, uv);
    }

    vec4 resultColor = vec4(1);
    resultColor.rgb = mix(vec4(0).rgb, textureBg.rgb, textureBg.a);
	vec4 texture = texture2D(inputTextureReal, uv);
	resultColor.rgb = mix(resultColor.rgb, texture.rgb, texture.a);
    gl_FragColor  = resultColor;
}
