precision mediump float;

uniform sampler2D inputTexture;
uniform sampler2D inputImage;
uniform vec4 bgColor;

varying vec2 uv;

uniform int hasImage;
uniform float imageAlpha;
uniform int hasVideo;
uniform float videoAlpha;

void main()
{
    vec4 resultColor = bgColor;
    if (hasImage == 1) {
        vec4 color = texture2D(inputImage, uv);
        resultColor.rgb = mix(resultColor.rgb, color.rgb, color.a * imageAlpha);
    }
    if (hasVideo == 1) {
        vec4 color = texture2D(inputTexture, uv);
        resultColor.rgb = mix(resultColor.rgb, color.rgb, color.a * videoAlpha);
    }
    
    gl_FragColor = resultColor;
}
