precision mediump float;

uniform sampler2D inputTexture;
uniform int imageWidth;
uniform int imageHeight;
uniform float intensity;

varying vec2 uv;

vec4 calcDim(sampler2D tex, vec2 screenSize, vec2 uv, float intensity)
{
    float weightArray[9];
    weightArray[0]= 0.2;
    weightArray[1]= 0.19;
    weightArray[2]= 0.17;
    weightArray[3]= 0.15;
    weightArray[4]= 0.13;
    weightArray[5]= 0.11;
    weightArray[6]= 0.08;
    weightArray[7]= 0.05;
    weightArray[8]= 0.02;

    vec4 sum            = vec4(0.0);
    vec2 uv0            = vec2(intensity/screenSize.x, intensity/screenSize.y)*1.25;
    vec4 realColor      = texture2D(inputTexture, uv)*weightArray[0];
    float sum_weight    = weightArray[0];

    for (int i=1;i<=8;i++)
    {
        vec2 pBottom    = uv+vec2(0.0, float(i))*uv0;
        vec2 pTop       = uv+vec2(0.0, float(-i))*uv0;
        sum+=texture2D(inputTexture, pBottom)*weightArray[i];
        sum+=texture2D(inputTexture, pTop)*weightArray[i];
        sum_weight+=weightArray[i]*2.0;
    }

    vec4 result = (sum+realColor)/sum_weight;
    result.a = 1.0;
    return result;
}

void main()
{
    vec2 screenSize = vec2(imageWidth, imageHeight);
    vec4 resultColor = calcDim(inputTexture, screenSize, uv, intensity);
    gl_FragColor = resultColor;
}
