precision mediump float;

uniform sampler2D inputTexture;
uniform int imageWidth;
uniform int imageHeight;
uniform float intensity;

varying vec2 uv;

vec3 mask = vec3(0.299, 0.587, 0.114);

float setMaskVal(vec4 color, vec3 weight)
{
    if (dot(color.rgb, weight) > 0.5) {
        return 0.0;//目标区域，高光区域
    } else {
        return 1.0;
    }
}

vec4 calcDim(sampler2D tex, vec2 screenSize, vec2 uv, float intensity)
{
    float weightArray[9];
    weightArray[0]= 0.2;
    weightArray[1]= 0.19;
    weightArray[2]= 0.17;
    weightArray[3]= 0.15;
    weightArray[4]= 0.13;
    weightArray[5]= 0.11;
    weightArray[6]= 0.08;
    weightArray[7]= 0.05;
    weightArray[8]= 0.02;

    vec4 sum            = vec4(0.0);
    vec2 uv0            = vec2(intensity/screenSize.x, intensity/screenSize.y)*1.25;
    vec4 color          = texture2D(inputTexture, uv);
    color.a = setMaskVal(color, mask);
    vec4 realColor    = color*weightArray[0];
    float sumWeight    = weightArray[0];

    for (int i=1;i<=8;i++)
    {
        vec2 pRight = uv+vec2(float(i), 0.0) * uv0;
        vec2 pLeft  = uv+vec2(float(-i), 0.0) * uv0;

        vec4 rightColor = texture2D(inputTexture, pRight);
        vec4 leftColor = texture2D(inputTexture, pLeft);
        rightColor.a = setMaskVal(rightColor, mask);
        leftColor.a = setMaskVal(leftColor, mask);
        sum+=rightColor*weightArray[i];
        sum+=leftColor*weightArray[i];
        sumWeight+=weightArray[i]*2.0;
    }

    vec4 result = (sum+realColor)/sumWeight;
    result.a = 1.0;
    return result;
}

void main()
{
    vec2 screenSize = vec2(imageWidth, imageHeight);
    vec4 resultColor = calcDim(inputTexture, screenSize, uv, intensity);
    gl_FragColor = resultColor;
}
