precision mediump float;
varying vec2 texCoord;

uniform float progress;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

float easeInOutQuint(float t)
{
    return t<0.5 ? 16.0*t*t*t*t*t : 1.0+16.0*(--t)*t*t*t*t;
}

void main() {
    float mProgress = 1.0 - easeInOutQuint(1.0 - progress);
    if(texCoord.y < mProgress)
        gl_FragColor = texture2D(inputImageTexture2,texCoord+vec2(0.0,1.0-mProgress));
    else
        gl_FragColor = texture2D(inputImageTexture,texCoord-vec2(0.0,mProgress));
}
