precision mediump float;
varying vec2 texCoord;

uniform float progress;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform float blurWidth;

float easeOutCubic(float t)
{
    return t * (t * t - 3.0*t + 3.0);
}

void main() {	
	float easeProgrss = easeOutCubic(progress);
    float factor = smoothstep(1.0 - easeProgrss - blurWidth, 1.0 - easeProgrss, texCoord.x);   
    vec4 baseColor = texture2D(inputImageTexture,texCoord);
    vec4 blendColor = texture2D(inputImageTexture2,texCoord);
    gl_FragColor = mix(baseColor, blendColor, factor);    
}
