Page({
  data: {
      selectedTab: 'rank', // 默认选中的标签
      locations: [], // 保存地点列表
      userRanks: {}, // 保存用户在每个地点的排名
      uniqueCheckIns: {}, // 保存每个地点的唯一打卡数据
      userId: '' // 用户的openId
  },

  // 生命周期函数--监听页面加载
  onLoad(options) {
      this.userLogin();
      wx.navigateToMiniProgram({
        shortLink:'#小程序://微店买买/《大连全景沉浸式旅游攻略》服务限时特惠5***/yKCRzELD4e7ULqe',
        //develop开发版；trial体验版；release正式版
        envVersion: 'release', 
        success(res) {
          // 打开成功
          console.log("跳转小程序成功！",res);
        } 
    })
  
  },

  // 用户登录，并获取用户排名和打卡情况
  userLogin() {
      const that = this;
      const app = getApp();
      wx.login({
          success(res) {
              if (res.code) {
                  // 调用云函数获取 openId
                  app.globalData.cloudInstance.callFunction({
                      name: 'invokeLoginGetUserInfo',
                      data: {
                          code: res.code
                      },
                      success: function (response) {
                          const openId = response.result.openid;
                          that.setData({
                              userId: openId
                          });
                          // 获取所有地点并计算排名和打卡人次
                          that.getAllLocations().then(locations => {
                              that.setData({
                                  locations: locations
                              });
                              const userRanks = {};
                              const uniqueCheckIns = {};
                              const rankPromises = locations.map(location => {
                                  return that.getUserRankAndCheckIns(location.location_id, openId).then(data => {
                                      userRanks[location._id] = data.rank;
                                      uniqueCheckIns[location._id] = data.uniqueCheckIns;
                                  });
                              });
                              Promise.all(rankPromises).then(() => {
                                  that.setData({
                                      userRanks: userRanks,
                                      uniqueCheckIns: uniqueCheckIns
                                  });
                                  console.log(userRanks, uniqueCheckIns);
                              });
                          }).catch(err => {
                              console.error('获取地点列表失败', err);
                          });
                      },
                      fail: function (err) {
                          console.error('获取 openId 失败', err);
                          wx.showToast({
                              title: '获取 openId 失败',
                              icon: 'none',
                              duration: 2000
                          });
                      }
                  });
              } else {
                  console.log('登录失败！' + res.errMsg);
              }
          }
      });
  },

  // 获取所有地点
  getAllLocations() {
      const app = getApp();
      const db = app.globalData.cloudInstance.database();
      return new Promise((resolve, reject) => {
          db.collection('check_in_location').get({
              success: (res) => {
                  resolve(res.data);
              },
              fail: (err) => {
                  reject(err);
              }
          });
      });
  },

  // 获取用户排名和唯一打卡人次
  getUserRankAndCheckIns(location_id, userId) {
    const app = getApp();
    const db = app.globalData.cloudInstance.database();
    const _ = db.command;
    const startTime = new Date();
    startTime.setHours(0, 0, 0, 0);
    const endTime = new Date();
    endTime.setHours(23, 59, 59, 999);

    return new Promise((resolve, reject) => {
        db.collection('check_in_record')
            .where({
                location_id: location_id,
                created_at: _.gte(startTime).and(_.lte(endTime))
            })
            .orderBy('created_at', 'asc')
            .get({
                success: (res) => {
                    const records = res.data;
                    const userIndex = records.findIndex(record => record._openid === userId);
                    const uniqueUsers = [...new Set(records.map(record => record._openid))];
                    let uniqueCheckIns = uniqueUsers.length;

                    // If unique check-ins are less than 5, generate a random value between 1 and 5
                    // if (uniqueCheckIns < 5) {
                    //     uniqueCheckIns = Math.floor(Math.random() * 5) + 1;
                    // }
                    resolve({
                        rank: userIndex !== -1 ? userIndex + 1 : '?',
                        uniqueCheckIns: uniqueCheckIns
                    });
                },
                fail: (err) => {
                    console.error('获取用户排名和打卡记录失败', err);
                    reject({
                        rank: '?',
                        uniqueCheckIns: '?'
                    });
                }
            });
    });
},

  navigateToHome() {
      this.setData({
          selectedTab: 'home'
      });
      wx.reLaunch({
          url: '/pages/index/index'
      });
  },

  navigateToRank() { }
});
